/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.core.context;

import cn.imaq.autumn.core.beans.BeanInfo;
import cn.imaq.autumn.core.beans.BeanWrapper;
import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.beans.populator.BeanPopulators;
import cn.imaq.autumn.core.beans.processor.AfterBeanCreateProcessor;
import cn.imaq.autumn.core.beans.processor.AfterBeanPopulateProcessor;
import cn.imaq.autumn.core.beans.processor.BeanProcessors;
import cn.imaq.autumn.core.beans.scanner.BeanScanners;
import cn.imaq.autumn.core.exception.BeanCreationException;
import cn.imaq.autumn.core.exception.BeanPopulationException;
import cn.imaq.autumn.cpscan.AutumnClasspathScan;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnContext {
    private static final Logger log = LoggerFactory.getLogger(AutumnContext.class);
    private String name;
    private AutumnContext parent;
    private volatile boolean scanned = false;
    private Queue<BeanInfo> beanInfos = new ConcurrentLinkedQueue<BeanInfo>();
    private Map<String, BeanInfo> beansByName = new ConcurrentHashMap<String, BeanInfo>();
    private Map<Class<?>, BeanInfo> beansByType = new ConcurrentHashMap();
    private Map<BeanInfo, Object> populatingBeans = new ConcurrentHashMap<BeanInfo, Object>();
    private Map<BeanInfo, Object> singletons = new ConcurrentHashMap<BeanInfo, Object>();
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public AutumnContext(String name) {
        this.name = name;
    }

    public AutumnContext(String name, AutumnContext parent) {
        this.name = name;
        this.parent = parent;
    }

    public synchronized void scanComponents() {
        if (this.scanned) {
            return;
        }
        BeanScanners.processAll(AutumnClasspathScan.getGlobalScanResult(), this);
        log.info(this.formatLog("scanning components ..."));
        this.scanned = true;
    }

    public void addBeanInfo(BeanInfo info) {
        log.info(this.formatLog("adding {}"), (Object)info);
        if (this.beansByType.containsKey(info.getType())) {
            log.warn(this.formatLog("already has a bean of type {}, ignoring the new one"), (Object)info.getType().getName());
            return;
        }
        this.beansByType.put(info.getType(), info);
        if (info.getName() != null && !info.getName().isEmpty()) {
            if (this.beansByName.containsKey(info.getName())) {
                log.warn(this.formatLog("already has a bean with name [{}], ignoring the new one"), (Object)info.getName());
                return;
            }
            this.beansByName.put(info.getName(), info);
        }
        this.beanInfos.add(info);
    }

    public Object getBeanByName(String name) {
        return this.getBeanByName(name, false);
    }

    public Object getBeanByName(String name, boolean populating) {
        BeanInfo info = this.findBeanInfoByName(name);
        if (info == null && this.parent != null) {
            return this.parent.getBeanByName(name, populating);
        }
        return this.getBeanByInfo(info, populating);
    }

    public <T> T getBeanByType(Class<? extends T> type) {
        return this.getBeanByType(type, false);
    }

    public <T> T getBeanByType(Class<? extends T> type, boolean populating) {
        BeanInfo info = this.findBeanInfoByType(type);
        if (info == null && this.parent != null) {
            return this.parent.getBeanByType(type, populating);
        }
        return (T)this.getBeanByInfo(info, populating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBeanByInfo(BeanInfo info, boolean populating) {
        if (info == null) {
            return null;
        }
        if (info.isSingleton()) {
            Object populatingBean;
            Object singletonBean = this.singletons.get(info);
            if (singletonBean != null) {
                return singletonBean;
            }
            if (populating && (populatingBean = this.populatingBeans.get(info)) != null) {
                return populatingBean;
            }
            BeanInfo beanInfo = info;
            synchronized (beanInfo) {
                Object populatingBean2;
                singletonBean = this.singletons.get(info);
                if (singletonBean != null) {
                    return singletonBean;
                }
                if (populating && (populatingBean2 = this.populatingBeans.get(info)) != null) {
                    return populatingBean2;
                }
                return this.getNewBeanByInfo(info, populating);
            }
        }
        return this.getNewBeanByInfo(info, populating);
    }

    private Object getNewBeanByInfo(BeanInfo info, boolean populating) {
        try {
            return this.createAndPopulateBean(info);
        }
        catch (BeanCreationException e) {
            log.error(this.formatLog("error creating {}: {}"), (Object)info, (Object)String.valueOf(e));
        }
        catch (BeanPopulationException e) {
            log.error(this.formatLog("error populating {}: {}"), (Object)info, (Object)String.valueOf(e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createAndPopulateBean(BeanInfo info) throws BeanCreationException, BeanPopulationException {
        BeanCreator creator = info.getCreator();
        BeanWrapper wrapper = new BeanWrapper(this, info, creator.createBean());
        BeanProcessors.get(AfterBeanCreateProcessor.class).forEach(x -> x.process(wrapper));
        Object beanInstance = wrapper.getBeanInstance();
        this.populatingBeans.put(info, beanInstance);
        try {
            BeanPopulators.populateBean(this, beanInstance);
            BeanProcessors.get(AfterBeanPopulateProcessor.class).forEach(x -> x.process(wrapper));
        }
        finally {
            this.populatingBeans.remove(info);
        }
        beanInstance = wrapper.getBeanInstance();
        if (info.isSingleton()) {
            this.singletons.put(info, beanInstance);
        }
        return beanInstance;
    }

    private BeanInfo findBeanInfoByName(String name) {
        return this.beansByName.get(name);
    }

    private BeanInfo findBeanInfoByType(Class<?> type) {
        BeanInfo result = this.beansByType.get(type);
        if (result == null) {
            for (BeanInfo info : this.beanInfos) {
                if (!type.isAssignableFrom(info.getType())) continue;
                if (result != null) {
                    log.warn(this.formatLog("more than one bean found with type {}"), (Object)type.getName());
                    return null;
                }
                result = info;
            }
            if (result != null) {
                this.beansByType.put(type, result);
            }
        }
        return result;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    private String formatLog(String msg) {
        return "Context [" + this.name + "] " + msg;
    }
}

