package cn.ipokerface.minio;

import cn.ipokerface.common.logback.LoggerAdapter;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;

/**
 * Created by       PokerFace
 * Create Date      2021/4/18.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
public class MinioInitializingBean extends LoggerAdapter implements InitializingBean {


    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    @Override
    public void afterPropertiesSet() throws Exception {

        if (StringUtils.isNotBlank(minioProperties.getBuckets())) {
            String[] buckets = minioProperties.getBuckets().split(",");
            if (buckets!=null){
                Arrays.stream(buckets).forEach(bucket -> {
                    try {
                        if (!minioClient.bucketExists(BucketExistsArgs.builder()
                                        .bucket(bucket)
                                .build())) {
                            minioClient.makeBucket(MakeBucketArgs.builder()
                                    .bucket(bucket)
                                    .build());
                        }
                    }catch (Exception e){
                        error(e);
                    }
                });
            }
        }


    }
}
