package cn.ipokerface.minio.controller;

import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.minio.MinioProperties;
import cn.ipokerface.minio.service.FileUploadService;
import cn.ipokerface.web.controller.BaseController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.rmi.ServerException;

/**
 * Created by       PokerFace
 * Create Date      2021/3/14.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@RestController
@RequestMapping("/upload")
public class UploadController extends BaseController {

    private static final Logger logger = LoggerFactory.getLogger(UploadController.class);

    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private MinioProperties minioProperties;


    @RequestMapping(value = "/standard", method = RequestMethod.POST)
    public ResultBody standard(@RequestParam("file") MultipartFile file,String bucket) throws IOException {

        bucket = StringUtils.isEmpty(bucket)?minioProperties.getDefaultBucket():bucket;
        try {
            String url = fileUploadService.upload(file.getInputStream(), file.getSize(),bucket, file.getOriginalFilename());
            return success(url);
        } catch (Exception e) {
            logger.error(" upload object into minio server error: {}", e.getMessage());
            throw new ServerException("upload error");
        }


    }
}
