package cn.ipokerface.minio.service;

import cn.ipokerface.common.exception.ServiceException;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.minio.MinioProperties;
import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.UUID;

/**
 * Created by       PokerFace
 * Create Date      2021/3/14.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Service
public class FileUploadServiceMinioImpl implements FileUploadService{

    private static final Logger logger = LoggerFactory.getLogger(FileUploadServiceMinioImpl.class);

    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioProperties minioProperties;

    @Override
    public String upload(InputStream file,long size,String bucket, String originalName) {
        String fileName = UUID.randomUUID().toString().replace("-","")+"."+ FilenameUtils.getExtension(originalName);

        try{
            minioClient.putObject(PutObjectArgs.builder()
                            .bucket(bucket)
                            .object(fileName)
                            .stream(file, size, PutObjectArgs.MAX_PART_SIZE)
                    .build());
            logger.debug("upload object into minio server bucket: {} object:{}",bucket, fileName);
            return StringUtils.isEmpty(minioProperties.getLocationPrefix()) ? minioClient.getObject(GetObjectArgs.builder()
                            .bucket(bucket)
                            .object(fileName)
                    .build()).object() :objectUrl(bucket, fileName);
        }catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }

    }


    public String objectUrl(String bucket, String name) {
        String prefix = StringUtils.isEmpty(minioProperties.getLocationPrefix())? minioProperties.getUrl() : minioProperties.getLocationPrefix();
        return new StringBuilder(prefix)
                .append(prefix.endsWith("/")?"":"/")
                .append(bucket).append("/")
                .append(name)
                .toString();
    }


}
