package cn.ipokerface.web.interceptor;

import cn.ipokerface.common.model.api.ResultBody;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by       PokerFace
 * Create Date      2020-11-12.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractInterceptor implements HandlerInterceptor {



    public void responseJson(HttpServletResponse response, String jsonString) throws IOException {
        response.setContentType("application/json; charset=utf-8");
        response.getOutputStream().write(jsonString.getBytes("utf-8"));
        response.getOutputStream().flush();
    }


    public void responseJson(HttpServletResponse response, ResultBody resultBody)throws IOException{
        this.responseJson(response, resultBody.toJsonString());
    }

}
