/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.async;

import org.shoulder.log.operation.context.OpLogContext;
import org.shoulder.log.operation.context.OpLogContextHolder;
import org.shoulder.log.operation.model.OperationLogDTO;

public abstract class AbstractOpLogAsyncRunner {
    private ThreadLocal<AbstractOpLogAsyncRunner> enhancerLocal = ThreadLocal.withInitial(() -> null);
    private OpLogContext opLogContext = OpLogContextHolder.getContext();

    AbstractOpLogAsyncRunner() {
    }

    void before() {
        if (this.notEnhancer()) {
            this.markThis();
        }
        if (this.shouldEnhancer() && this.opLogContext != null) {
            OpLogContextHolder.setContext(this.opLogContext);
        }
        this.opLogContext = null;
    }

    void error() {
        OperationLogDTO logDTO;
        OpLogContext opLogContext = OpLogContextHolder.getContext();
        if (opLogContext != null && (logDTO = opLogContext.getOperationLog()) != null) {
            logDTO.setResultFail();
        }
    }

    void after() {
        if (!this.shouldEnhancer()) {
            return;
        }
        OpLogContextHolder.clean();
        this.enhancerLocal.remove();
    }

    protected boolean shouldEnhancer() {
        if (this.enhancerLocal.get() == null) {
            throw new IllegalStateException("must has been enhancer");
        }
        return this.enhancerLocal.get() == this;
    }

    protected synchronized void markThis() {
        if (this.enhancerLocal.get() != null) {
            throw new IllegalStateException("this runnable has enhancer more than once.");
        }
        this.enhancerLocal.set(this);
    }

    protected boolean notEnhancer() {
        return this.enhancerLocal.get() == null;
    }
}

