/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.shoulder.log.operation.model.Operator;
import org.shoulder.log.operation.model.SystemOperator;
import org.springframework.util.Assert;

public class OpLogContext {
    private static ThreadLocal<Operator> currentOperatorThreadLocal = new ThreadLocal();
    private OpLogContext parent = null;
    private OperationLogDTO operationLog;
    private List<Operable> operableObjects;
    private Operator operator;
    private boolean autoLog = true;
    private boolean logWhenThrow = true;

    public static void setDefaultOperator(Operator operator) {
        currentOperatorThreadLocal.set(operator);
    }

    public static Operator getCurrentOperator() {
        Operator operator = currentOperatorThreadLocal.get();
        return operator == null ? SystemOperator.getInstance() : operator;
    }

    public static void cleanDefaultOperator() {
        currentOperatorThreadLocal.remove();
    }

    OpLogContext() {
        Operator operator = currentOperatorThreadLocal.get();
        this.setOperator(operator != null ? operator : SystemOperator.getInstance());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OpLogContext copy(OpLogContext lastOpLogContext) {
        if (lastOpLogContext != null) {
            return new OpLogContext().setOperator(lastOpLogContext.getOperator()).setAutoLog(lastOpLogContext.isAutoLog()).setLogWhenThrow(lastOpLogContext.isLogWhenThrow());
        }
        return new OpLogContext();
    }

    public void setOperableObjects(Collection<? extends Operable> operableObjs) {
        if (operableObjs != null) {
            this.operableObjects = new ArrayList<Operable>(operableObjs);
        }
    }

    public OpLogContext getParent() {
        return this.parent;
    }

    public OperationLogDTO getOperationLog() {
        return this.operationLog;
    }

    public List<Operable> getOperableObjects() {
        return this.operableObjects;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isAutoLog() {
        return this.autoLog;
    }

    public boolean isLogWhenThrow() {
        return this.logWhenThrow;
    }

    public OpLogContext setParent(OpLogContext parent) {
        this.parent = parent;
        return this;
    }

    public OpLogContext setOperationLog(OperationLogDTO operationLog) {
        this.operationLog = operationLog;
        return this;
    }

    public OpLogContext setOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public OpLogContext setAutoLog(boolean autoLog) {
        this.autoLog = autoLog;
        return this;
    }

    public OpLogContext setLogWhenThrow(boolean logWhenThrow) {
        this.logWhenThrow = logWhenThrow;
        return this;
    }

    public static final class Builder {
        private final OpLogContext opLogContext = new OpLogContext();

        private Builder() {
        }

        public static Builder anOpLogContext() {
            return new Builder();
        }

        public Builder parent(OpLogContext parent) {
            this.opLogContext.setParent(parent);
            return this;
        }

        public Builder operationLog(OperationLogDTO operationLog) {
            this.opLogContext.setOperationLog(operationLog);
            return this;
        }

        public Builder operableObjects(Collection<? extends Operable> operableObjects) {
            this.opLogContext.setOperableObjects(operableObjects);
            return this;
        }

        public Builder currentOperator(Operator currentOperator) {
            this.opLogContext.setOperator(currentOperator);
            return this;
        }

        public Builder autoLog(boolean autoLog) {
            this.opLogContext.setAutoLog(autoLog);
            return this;
        }

        public Builder logWhenThrow(boolean logWhenThrow) {
            this.opLogContext.setLogWhenThrow(logWhenThrow);
            return this;
        }

        public OpLogContext build() {
            Assert.notNull((Object)this.opLogContext.getOperator(), (String)"currentOperator can't be null!");
            return this.opLogContext;
        }
    }
}

