/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.context;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.context.OpLogContext;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.shoulder.log.operation.model.Operator;
import org.springframework.beans.BeansException;
import org.springframework.util.CollectionUtils;

public class OpLogContextHolder {
    private static final Logger log = LoggerFactory.getLogger(OpLogContextHolder.class);
    private static final ThreadLocal<OpLogContext> CURRENT_OP_LOG_CONTEXT = new ThreadLocal();
    private static OperationLogger operationLogger;

    public static void log() {
        OpLogContext context = CURRENT_OP_LOG_CONTEXT.get();
        if (context != null) {
            OperationLogDTO opLog = OpLogContextHolder.getLog();
            List<Operable> operableCollection = OpLogContextHolder.getOperableObjects();
            if (opLog.getEndTime() == null) {
                opLog.setEndTime(Instant.now());
            }
            if (CollectionUtils.isEmpty(operableCollection)) {
                operationLogger.log(opLog);
            } else {
                operationLogger.log(opLog, operableCollection);
            }
        }
    }

    @Nonnull
    public static OpLogContext getContextOrException() {
        OpLogContext context = CURRENT_OP_LOG_CONTEXT.get();
        if (context == null) {
            throw new IllegalThreadStateException("No OpLogContext in concurrentThread! Maybe your method miss @OperationLog or used [SpringAop] incorrectly! Thread - [" + Thread.currentThread().getName() + "]. ");
        }
        return context;
    }

    @Nullable
    public static OpLogContext getContext() {
        return CURRENT_OP_LOG_CONTEXT.get();
    }

    public static void setContext(OpLogContext opLogContext) {
        CURRENT_OP_LOG_CONTEXT.set(opLogContext);
    }

    public static OperationLogDTO getLog() {
        return OpLogContextHolder.getContextOrException().getOperationLog();
    }

    public static void setLog(OperationLogDTO entity) {
        OpLogContextHolder.getContextOrException().setOperationLog(entity);
    }

    public static Operator getOperator() {
        return OpLogContextHolder.getContextOrException().getOperator();
    }

    public static void setOperator(Operator entity) {
        OpLogContextHolder.getContextOrException().setOperator(entity);
    }

    public static void setOperableObject(Operable operableObj) {
        OpLogContextHolder.getContextOrException().getOperationLog().setOperableObject(operableObj);
    }

    public static List<Operable> getOperableObjects() {
        return OpLogContextHolder.getContextOrException().getOperableObjects();
    }

    public static void setOperableObjects(Collection<? extends Operable> operableObjs) {
        OpLogContextHolder.getContextOrException().setOperableObjects(new ArrayList<Operable>(operableObjs));
    }

    public static void addOperableObjects(Collection<? extends Operable> operableObjs) {
        if (operableObjs == null) {
            return;
        }
        List<Operable> local = OpLogContextHolder.getOperableObjects();
        if (local != null) {
            local.addAll(operableObjs);
        } else {
            OpLogContextHolder.setOperableObjects(new ArrayList<Operable>(operableObjs));
        }
    }

    public static boolean isEnableAutoLog() {
        return OpLogContextHolder.getContextOrException().isAutoLog();
    }

    public static void closeAutoLog() {
        OpLogContextHolder.getContextOrException().setAutoLog(false);
    }

    public static void enableAutoLog() {
        OpLogContextHolder.getContextOrException().setAutoLog(true);
    }

    public static boolean isLogWhenThrow() {
        return OpLogContextHolder.getContextOrException().isLogWhenThrow();
    }

    public static void setLogWhenThrow(boolean logWhenThrow) {
        OpLogContextHolder.getContextOrException().setLogWhenThrow(logWhenThrow);
    }

    public static void clean() {
        CURRENT_OP_LOG_CONTEXT.remove();
    }

    public static void setOperationLogger(OperationLogger opLogger) throws BeansException {
        operationLogger = opLogger;
        if (opLogger == null) {
            log.warn("operationLogger is null!");
        } else {
            log.info("operationLogger:" + opLogger.getClass().getSimpleName());
        }
    }
}

