/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.context;

import javax.annotation.Nonnull;
import org.shoulder.log.operation.context.OpLogContext;
import org.shoulder.log.operation.context.OperationContextStrategy;

public enum OperationContextStrategyEnum implements OperationContextStrategy
{
    USE_DEFAULT(-1, -1),
    ALWAYS_NEW(0, 0),
    NEW_OR_IGNORE(0, 1),
    IGNORE_OR_REUSE(1, 4),
    EX_OR_REUSE(2, 4);

    public static OperationContextStrategy DEFAULT;
    int onMissingContext;
    int onExistContext;

    private OperationContextStrategyEnum(int onMissingContext, int onExistContext) {
        this.onMissingContext = onMissingContext;
        this.onExistContext = onExistContext;
    }

    public static OperationContextStrategy getDefault() {
        return DEFAULT;
    }

    public static void setDefault(OperationContextStrategy defaultStrategy) {
        DEFAULT = defaultStrategy;
    }

    @Override
    @Nonnull
    public OpLogContext onMissingContext() {
        switch (this.onMissingContext) {
            case 0: {
                return OpLogContext.builder().currentOperator(OpLogContext.getCurrentOperator()).build();
            }
            case 1: {
                return OpLogContext.builder().currentOperator(OpLogContext.getCurrentOperator()).autoLog(false).logWhenThrow(false).build();
            }
            case 2: {
                throw new IllegalStateException("can't invoke without an opLogContext in thread with such onMissingContext strategy!");
            }
        }
        throw new IllegalStateException("illegal strategy(value=" + this.onMissingContext + ")!");
    }

    @Override
    @Nonnull
    public OpLogContext onExistContext(OpLogContext existed) {
        switch (this.onExistContext) {
            case 0: {
                return OpLogContext.builder().currentOperator(OpLogContext.getCurrentOperator()).build();
            }
            case 1: {
                return OpLogContext.builder().currentOperator(OpLogContext.getCurrentOperator()).autoLog(false).logWhenThrow(false).build();
            }
            case 2: {
                throw new IllegalStateException("can't invoke with already had an opLogContext in thread!");
            }
            case 3: {
                return OpLogContext.copy(existed).setParent(existed);
            }
            case 4: {
                return existed;
            }
        }
        throw new IllegalStateException("illegal strategy(value=" + this.onExistContext + ")!");
    }

    static {
        DEFAULT = NEW_OR_IGNORE;
    }
}

