/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.core.context.AppContext;
import org.shoulder.core.context.AppInfo;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.context.OpLogContext;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.shoulder.log.operation.model.Operator;

public class OperationLogFactory {
    public static OperationLogDTO create(String operation) {
        Operator currentOperator = OpLogContext.getCurrentOperator();
        return new OperationLogDTO(operation).setOperator(currentOperator).setAppId(AppInfo.appId()).setInstanceId(AppInfo.instanceId()).setTenantCode(AppContext.getTenantCode());
    }

    public static List<OperationLogDTO> createFromTemplate(OperationLogDTO operationLogTemplate, @Nullable Collection<? extends Operable> operableList) {
        if (operationLogTemplate == null || CollectionUtils.isEmpty(operableList)) {
            return Collections.singletonList(operationLogTemplate);
        }
        ArrayList<OperationLogDTO> resultLogs = new ArrayList<OperationLogDTO>(operableList.size());
        for (Operable operable : operableList) {
            OperationLogDTO opLog = operationLogTemplate.clone();
            resultLogs.add(opLog.setOperableObject(operable));
        }
        return resultLogs;
    }
}

