/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.enums;

import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.log.operation.model.OperateResult;

public enum OperationResult {
    SUCCESS(0),
    FAIL(1),
    PARTIAL(2);

    public final int code;

    private OperationResult(int code) {
        this.code = code;
    }

    public static OperationResult of(boolean success) {
        return success ? SUCCESS : FAIL;
    }

    public static OperationResult of(boolean hasSuccess, boolean hasFail) {
        return hasSuccess && hasFail ? PARTIAL : (hasFail ? FAIL : SUCCESS);
    }

    public static OperationResult of(Collection<? extends OperateResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return SUCCESS;
        }
        boolean hasSuccess = false;
        boolean hasFail = false;
        for (OperateResult operateResult : results) {
            if (hasSuccess && hasFail) break;
            if (operateResult.success()) {
                hasSuccess = true;
                continue;
            }
            hasFail = true;
        }
        return OperationResult.of(hasSuccess, hasFail);
    }

    public int getCode() {
        return this.code;
    }
}

