/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.format.covertor;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.shoulder.log.operation.format.OperationLogParamValueConverter;
import org.shoulder.log.operation.model.OperationLogDTO;

public class DefaultOperationLogParamValueConverter
implements OperationLogParamValueConverter {
    private final String nullValueOutputText;

    public DefaultOperationLogParamValueConverter() {
        this("");
    }

    public DefaultOperationLogParamValueConverter(String nullValueOutputText) {
        this.nullValueOutputText = nullValueOutputText;
    }

    @Override
    public List<String> convert(@Nonnull OperationLogDTO opLog, @Nullable Object paramValue, Class<?> methodParamClazz) {
        return this.toStringList(paramValue);
    }

    protected List<String> toStringList(@Nullable Object obj) {
        LinkedList<String> resultList = new LinkedList<String>();
        if (obj == null) {
            this.addNullValue(resultList);
            return resultList;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof Iterable) {
            Iterable iterableToLogParam = (Iterable)obj;
            iterableToLogParam.forEach(item -> {
                if (item != null) {
                    resultList.addAll(this.toStringList(item));
                } else {
                    this.addNullValue(resultList);
                }
            });
        } else if (clazz.isArray()) {
            Object[] objects;
            for (Object object : objects = (Object[])obj) {
                if (object != null) {
                    resultList.addAll(this.toStringList(object));
                    continue;
                }
                this.addNullValue(resultList);
            }
        } else {
            resultList.add(obj.toString());
        }
        return resultList;
    }

    private void addNullValue(List<String> resultList) {
        resultList.add(this.nullValueOutputText);
    }
}

