/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.format.covertor;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.log.operation.format.OperationLogParamValueConverter;

public class OperationLogParamValueConverterHolder {
    private static Map<Class<? extends OperationLogParamValueConverter>, OperationLogParamValueConverter> converterMap;
    private static OperationLogParamValueConverter defaultConvert;

    @Nonnull
    public static OperationLogParamValueConverter getConvert(Class<? extends OperationLogParamValueConverter> convertClazz) {
        return converterMap.getOrDefault(convertClazz, defaultConvert);
    }

    public static void init(@Nonnull Collection<OperationLogParamValueConverter> converterList, OperationLogParamValueConverter defaultConvert) {
        boolean hasConverter = CollectionUtils.isNotEmpty(converterList);
        converterMap = new HashMap<Class<? extends OperationLogParamValueConverter>, OperationLogParamValueConverter>(converterList.size());
        if (hasConverter) {
            converterList.forEach(OperationLogParamValueConverterHolder::addConverter);
        }
        if (defaultConvert == null) {
            throw new IllegalArgumentException("defaultConvert can't be null!");
        }
        OperationLogParamValueConverterHolder.defaultConvert = defaultConvert;
    }

    private static void addConverter(OperationLogParamValueConverter converter) {
        if (converter == null) {
            throw new InvalidParameterException("param converter can't be null");
        }
        converterMap.put(converter.getClass(), converter);
    }
}

