/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.format.impl;

import org.shoulder.core.util.StringUtils;

public class KeyValueContextBuilder {
    private final StringBuilder context = new StringBuilder();
    private final String keyValueSplit;
    private final String keyPairSplit;

    public KeyValueContextBuilder() {
        this(":", ",");
    }

    public KeyValueContextBuilder(String keyValueSplit, String keyPairSplit) {
        this.keyValueSplit = keyValueSplit;
        this.keyPairSplit = keyPairSplit;
    }

    public KeyValueContextBuilder addIfValueNotEmpty(String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.add(key, value);
        }
        return this;
    }

    public KeyValueContextBuilder add(String key, Object value) {
        this.context.append(key).append(this.keyValueSplit).append("\"").append(value).append("\"").append(this.keyPairSplit);
        return this;
    }

    public String formatResult() {
        this.context.setLength(this.context.length() - 1);
        return this.context.toString();
    }
}

