/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.format.impl;

import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.core.context.AppInfo;
import org.shoulder.core.exception.BaseRuntimeException;
import org.shoulder.log.operation.format.OperationLogFormatter;
import org.shoulder.log.operation.format.impl.KeyValueContextBuilder;
import org.shoulder.log.operation.model.OpLogParam;
import org.shoulder.log.operation.model.OperationLogDTO;

public class ShoulderOpLogFormatter
implements OperationLogFormatter {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(AppInfo.dateTimeFormat(), AppInfo.defaultLocale());
    private static final List<Field> opLogStrFields = Arrays.stream(OperationLogDTO.class.getDeclaredFields()).filter(field -> CharSequence.class.isAssignableFrom(field.getType())).peek(field -> field.setAccessible(true)).collect(Collectors.toList());

    public static String formatParam(String operation, OpLogParam param) {
        if (CollectionUtils.isEmpty(param.getValue())) {
            throw new IllegalStateException("operationParam.values is empty!");
        }
        String name = operation + "." + param.getName();
        StringJoiner valueJoiner = new StringJoiner(",");
        param.getValue().stream().filter(StringUtils::isEmpty).map(v -> name + v).forEach(valueJoiner::add);
        return "{\"name\"=\"" + name + "\", \"value\"=\"" + valueJoiner.toString() + "\"}";
    }

    @Override
    public String format(OperationLogDTO opLog) {
        KeyValueContextBuilder builder = new KeyValueContextBuilder();
        opLogStrFields.forEach(field -> {
            try {
                Object value = field.get(opLog);
                if (value == null) {
                    return;
                }
                builder.add(field.getName(), (String)value);
            }
            catch (IllegalAccessException e) {
                throw new BaseRuntimeException("format opLog fail", (Throwable)e);
            }
        });
        builder.add("terminalType", String.valueOf(opLog.getTerminalType().getCode())).add("result", String.valueOf(opLog.getResult().getCode())).add("operationTime", DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(opLog.getOperationTime(), AppInfo.timeZone().toZoneId())));
        if (opLog.getEndTime() != null) {
            builder.add("endTime", DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(opLog.getEndTime(), AppInfo.timeZone().toZoneId())));
        }
        if (CollectionUtils.isNotEmpty(opLog.getDetailItems())) {
            StringJoiner detailsStr = new StringJoiner(",", "[", "]");
            opLog.getDetailItems().stream().filter(Objects::nonNull).forEach(detailsStr::add);
            builder.add("detailItems", detailsStr.toString());
        }
        if (CollectionUtils.isNotEmpty(opLog.getParams())) {
            StringJoiner sj = new StringJoiner(",", "[", "]");
            opLog.getParams().stream().map(param -> ShoulderOpLogFormatter.formatParam(opLog.getOperation(), param)).forEach(sj::add);
            builder.add("params", sj.toString());
        }
        if (MapUtils.isNotEmpty(opLog.getExtFields())) {
            opLog.getExtFields().forEach(builder::add);
        }
        return builder.formatResult();
    }
}

