/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.context.OperationLogFactory;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.logger.OperationLoggerInterceptor;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperationLogger
implements OperationLogger {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<OperationLoggerInterceptor> logInterceptors = new LinkedList<OperationLoggerInterceptor>();

    @Override
    public void log(@Nonnull OperationLogDTO opLog) {
        try {
            this.beforeLog(opLog);
            this.doLog(opLog);
            this.afterLog(opLog);
        }
        catch (Exception e) {
            this.handleLogException(e, opLog);
        }
    }

    @Override
    public void log(@Nonnull Collection<? extends OperationLogDTO> opLogList) {
        opLogList.forEach(this::log);
    }

    @Override
    public void log(@Nonnull OperationLogDTO opLog, List<? extends Operable> operableList) {
        operableList = this.beforeAssembleBatchLogs(opLog, operableList);
        List<OperationLogDTO> opLogs = OperationLogFactory.createFromTemplate(opLog, operableList);
        opLogs = this.afterAssembleBatchLogs(opLogs);
        this.log(opLogs);
    }

    protected abstract void doLog(OperationLogDTO var1);

    protected void handleLogException(Exception e, OperationLogDTO opLog) {
        this.log.warn("Log is not qualified! -- " + e.getMessage() + String.valueOf(opLog), (Throwable)e);
    }

    private List<? extends Operable> beforeAssembleBatchLogs(OperationLogDTO template, List<? extends Operable> operableCollection) {
        List<? extends Operable> result = operableCollection;
        for (OperationLoggerInterceptor interceptor : this.logInterceptors) {
            result = interceptor.beforeAssembleBatchLogs(template, result);
        }
        return result;
    }

    private List<? extends OperationLogDTO> afterAssembleBatchLogs(List<? extends OperationLogDTO> operationLogEntities) {
        List<? extends OperationLogDTO> result = operationLogEntities;
        for (OperationLoggerInterceptor interceptor : this.logInterceptors) {
            result = interceptor.afterAssembleBatchLogs(result);
        }
        return result;
    }

    private void beforeLog(OperationLogDTO opLog) {
        this.logInterceptors.forEach(listener -> listener.beforeLog(opLog));
    }

    private void afterLog(OperationLogDTO opLog) {
        this.logInterceptors.forEach(listener -> listener.afterLog(opLog));
    }

    @Override
    public void addInterceptor(OperationLoggerInterceptor logInterceptor) {
        this.logInterceptors.add(logInterceptor);
        if (this.log.isDebugEnabled()) {
            this.log.debug("add a OperationLogInterceptor: " + logInterceptor.getClass().getName());
        }
    }
}

