/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.logger.OperationLoggerInterceptor;
import org.shoulder.log.operation.model.OperationLogDTO;

public class AsyncOperationLogger
implements OperationLogger {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private OperationLogger delegate;
    private ExecutorService executorService;

    @Override
    public void log(@Nonnull OperationLogDTO opLog) {
        this.executorService.execute(() -> this.delegate.log(opLog));
    }

    @Override
    public void log(@Nonnull Collection<? extends OperationLogDTO> opLogList) {
        this.executorService.execute(() -> this.delegate.log(opLogList));
    }

    @Override
    public void log(@Nonnull OperationLogDTO opLog, List<? extends Operable> operableList) {
        this.executorService.execute(() -> this.delegate.log(opLog, operableList));
    }

    @Override
    public void addInterceptor(OperationLoggerInterceptor logInterceptor) {
        this.delegate.addInterceptor(logInterceptor);
    }

    public AsyncOperationLogger setLogger(@Nonnull OperationLogger delegate) {
        this.delegate = delegate;
        return this;
    }

    public OperationLogger getDelegate() {
        return this.delegate;
    }

    public Executor getExecutorService() {
        return this.executorService;
    }

    public AsyncOperationLogger setExecutorService(@Nonnull ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @PreDestroy
    public void preDestroy() {
        try {
            this.log.info("{} clean start...", (Object)this.getClass().getSimpleName());
            this.executorService.shutdown();
            this.log.info("{} clean finished.", (Object)this.getClass().getSimpleName());
        }
        catch (Exception e) {
            this.log.error(this.getClass().getSimpleName() + " clean FAIL! - ", (Throwable)e);
        }
    }
}

