/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.logger.OperationLoggerInterceptor;
import org.shoulder.log.operation.model.OperationLogDTO;

public class BufferedOperationLogger
implements OperationLogger {
    private final Queue<OperationLogDTO> logBuffer;
    private final OperationLogger delegate;
    private ScheduledExecutorService scheduledExecutorService;
    private final int flushThreshold;
    private final int perFlushMax;
    private final AtomicLong lastLogTime = new AtomicLong(0L);
    private final AtomicBoolean flushing = new AtomicBoolean(false);

    @Override
    public void log(@Nonnull OperationLogDTO opLog) {
        this.logBuffer.add(opLog);
        int current = this.logBuffer.size();
        if (current >= this.flushThreshold) {
            this.consumerLog();
        }
    }

    public BufferedOperationLogger(Queue<OperationLogDTO> logBuffer, OperationLogger delegate, ScheduledExecutorService scheduledExecutorService, long flushInterval, int flushThreshold, int perFlushMax) {
        this.logBuffer = logBuffer;
        this.delegate = delegate;
        this.scheduledExecutorService = scheduledExecutorService;
        this.flushThreshold = flushThreshold;
        this.perFlushMax = perFlushMax;
        scheduledExecutorService.scheduleAtFixedRate(this::consumerLog, flushInterval, flushInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void log(@Nonnull Collection<? extends OperationLogDTO> opLogList) {
        this.delegate.log(opLogList);
    }

    @Override
    public void log(@Nonnull OperationLogDTO opLog, List<? extends Operable> operableList) {
        this.delegate.log(opLog, operableList);
    }

    @Override
    public void addInterceptor(OperationLoggerInterceptor logInterceptor) {
        this.delegate.addInterceptor(logInterceptor);
    }

    public OperationLogger getDelegate() {
        return this.delegate;
    }

    public void consumerLog() {
        OperationLogDTO temp;
        if (!this.flushing.compareAndSet(false, true)) {
            return;
        }
        LinkedList<OperationLogDTO> opLogList = new LinkedList<OperationLogDTO>();
        while ((temp = this.logBuffer.poll()) != null) {
            opLogList.add(temp);
            if (opLogList.size() != this.perFlushMax) continue;
            this.delegate.log(opLogList);
            this.lastLogTime.set(System.currentTimeMillis());
            opLogList = new LinkedList();
        }
        if (CollectionUtils.isNotEmpty(opLogList)) {
            this.delegate.log(opLogList);
            this.lastLogTime.set(System.currentTimeMillis());
        }
        this.flushing.set(false);
    }

    @PreDestroy
    public void preDestroy() {
        this.consumerLog();
    }
}

