/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger.impl;

import java.sql.Timestamp;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.shoulder.core.util.JsonUtils;
import org.shoulder.log.operation.logger.AbstractOperationLogger;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcOperationLogger
extends AbstractOperationLogger
implements OperationLogger {
    private final JdbcTemplate jdbcTemplate;
    private static final String ALL_INSERT_COLUMNS = "app_id, instance_id, user_id, user_name, user_real_name, user_org_id, user_org_name, terminal_type, terminal_address, terminal_id, terminal_info, operation, object_type, object_id, object_name, detail, detail_key, detail_item, operation_param,result, error_code, operation_time, end_time, duration, trace_id, relation_id, tenant_code, extended_field0";
    private static final String VALUES = "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String BATCH_INSERT = "INSERT INTO log_operation (app_id, instance_id, user_id, user_name, user_real_name, user_org_id, user_org_name, terminal_type, terminal_address, terminal_id, terminal_info, operation, object_type, object_id, object_name, detail, detail_key, detail_item, operation_param,result, error_code, operation_time, end_time, duration, trace_id, relation_id, tenant_code, extended_field0) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final int FIELD_NUM = "app_id, instance_id, user_id, user_name, user_real_name, user_org_id, user_org_name, terminal_type, terminal_address, terminal_id, terminal_info, operation, object_type, object_id, object_name, detail, detail_key, detail_item, operation_param,result, error_code, operation_time, end_time, duration, trace_id, relation_id, tenant_code, extended_field0".split(",").length;

    public JdbcOperationLogger(DataSource dataSource) {
        assert (ALL_INSERT_COLUMNS.split(",").length == VALUES.split(",").length);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void log(@Nonnull Collection<? extends OperationLogDTO> opLogList) {
        this.jdbcTemplate.batchUpdate(BATCH_INSERT, this.flatFieldsToArray(opLogList));
        this.log.debug("persistent {} opLogs with jdbc.", (Object)opLogList.size());
    }

    @Override
    protected void doLog(OperationLogDTO opLog) {
        this.log(Collections.singletonList(opLog));
    }

    private List<Object[]> flatFieldsToArray(Collection<? extends OperationLogDTO> opLogList) {
        return opLogList.stream().map(this::flatFieldsToArray).collect(Collectors.toList());
    }

    private <T extends OperationLogDTO> Object[] flatFieldsToArray(T opLog) {
        Object[] fields = new Object[FIELD_NUM];
        fields[0] = opLog.getAppId();
        fields[1] = opLog.getInstanceId();
        fields[2] = opLog.getUserId();
        fields[3] = opLog.getUserName();
        fields[4] = opLog.getUserRealName();
        fields[5] = opLog.getUserOrgId();
        fields[6] = opLog.getUserOrgName();
        fields[7] = opLog.getTerminalType().getCode();
        fields[8] = opLog.getRemoteAddress();
        fields[9] = opLog.getTerminalId();
        fields[10] = opLog.getTerminalInfo();
        fields[11] = opLog.getOperation();
        fields[12] = opLog.getObjectType();
        fields[13] = opLog.getObjectId();
        fields[14] = opLog.getObjectName();
        fields[15] = opLog.getDetail();
        fields[16] = opLog.getDetailKey();
        fields[17] = CollectionUtils.isEmpty(opLog.getDetailItems()) ? null : JsonUtils.toJson(opLog.getDetailItems());
        fields[18] = CollectionUtils.isEmpty(opLog.getParams()) ? null : JsonUtils.toJson(opLog.getParams());
        fields[19] = opLog.getResult().getCode();
        fields[20] = opLog.getErrorCode();
        fields[21] = Timestamp.from(opLog.getOperationTime());
        fields[22] = Timestamp.from(opLog.getEndTime());
        fields[23] = Duration.between(opLog.getOperationTime(), opLog.getEndTime()).toMillis();
        fields[24] = opLog.getTraceId();
        fields[25] = null;
        fields[26] = opLog.getTenantCode();
        fields[27] = MapUtils.isEmpty(opLog.getExtFields()) ? null : JsonUtils.toJson(opLog.getExtFields());
        return fields;
    }
}

