/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger.impl;

import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;
import org.shoulder.log.operation.format.OperationLogFormatter;
import org.shoulder.log.operation.logger.AbstractOperationLogger;
import org.shoulder.log.operation.logger.OperationLogger;
import org.shoulder.log.operation.model.OperationLogDTO;

public class LogOperationLogger
extends AbstractOperationLogger
implements OperationLogger {
    private static final Logger log = LoggerFactory.getLogger(LogOperationLogger.class);
    private static final String DEFAULT_OPERATION_LOGGER_NAME = "OPERATION_LOGGER";
    private final OperationLogFormatter operationLogFormatter;
    private final Logger opLogger;

    public LogOperationLogger(OperationLogFormatter operationLogFormatter) {
        this(operationLogFormatter, DEFAULT_OPERATION_LOGGER_NAME);
    }

    public LogOperationLogger(OperationLogFormatter operationLogFormatter, String loggerName) {
        this.operationLogFormatter = operationLogFormatter;
        this.opLogger = this.getOperationLogger(loggerName);
    }

    @Override
    protected void doLog(OperationLogDTO opLog) {
        this.opLogger.info(this.operationLogFormatter.format(opLog));
    }

    private Logger getOperationLogger(String loggerName) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (logger != null) {
            log.debug("use '{}' as opLogger", (Object)loggerName);
            return logger;
        }
        throw new RuntimeException("No OperationLogger named " + loggerName + " in LoggerFactory! Please check if there were any logger that name='" + loggerName + "' in your logback.xml.");
    }
}

