/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.logger.intercept;

import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.log.operation.format.impl.ShoulderOpLogFormatter;
import org.shoulder.log.operation.logger.intercept.OperationLogValidator;
import org.shoulder.log.operation.model.OpLogParam;
import org.shoulder.log.operation.model.OperationLogDTO;
import org.springframework.util.Assert;

public class ShoulderOperationLogValidator
implements OperationLogValidator {
    @Override
    public void validate(OperationLogDTO log) {
        Assert.notNull((Object)log, (String)"log is null.");
        this.validateRequiredFields(log);
        this.validateLengthLimit(log);
        if (CollectionUtils.isNotEmpty(log.getParams()) && "true".equals(System.getProperty("intellij.debug.agent"))) {
            log.getParams().forEach(this::validate);
            StringJoiner sj = new StringJoiner(",", "[", "]");
            log.getParams().stream().map(param -> ShoulderOpLogFormatter.formatParam(log.getOperation(), param)).forEach(sj::add);
            int maxParamLength = 2048;
            this.assertSmallerLimit(sj.length(), maxParamLength, "opLogParam");
        }
    }

    protected void validateRequiredFields(OperationLogDTO log) {
        Assert.hasText((String)log.getUserId(), (String)"userId is blank.");
        Assert.notNull((Object)((Object)log.getTerminalType()), (String)"terminalType is null.");
        Assert.hasText((String)log.getOperation(), (String)"operation is blank.");
        Assert.notNull((Object)log.getOperationTime(), (String)"operationTime is null.");
        Assert.notNull((Object)((Object)log.getResult()), (String)"result is null.");
        Assert.hasText((String)log.getAppId(), (String)"appId is blank.");
    }

    protected void validateLengthLimit(OperationLogDTO log) {
        this.assertLengthLimit(log.getAppId(), 128, "appId");
        this.assertLengthLimit(log.getUserOrgId(), 128, "userOrgId");
        this.assertLengthLimit(log.getUserId(), 128, "userId");
        this.assertLengthLimit(log.getUserName(), 128, "userName");
        this.assertLengthLimit(log.getRemoteAddress(), 255, "remoteAddress");
        this.assertLengthLimit(log.getTerminalId(), 128, "terminalId");
        this.assertLengthLimit(log.getObjectType(), 128, "objectType");
        this.assertLengthLimit(log.getObjectId(), 128, "objectId");
        this.assertLengthLimit(log.getObjectName(), 255, "objectName");
        this.assertLengthLimit(log.getOperation(), 255, "operation");
        this.assertLengthLimit(log.getDetailKey(), 128, "detailKey");
        if (log.getDetailItems() != null && log.getDetailItems().isEmpty()) {
            this.assertSmallerLimit(log.getDetailItems().stream().map(String::length).reduce(Integer::sum).orElse(0), 4096, "detail");
        }
    }

    protected void validate(OpLogParam param) {
        if (param != null) {
            Assert.hasText((String)param.getName(), (String)"opLogParam.name is blank.");
        }
    }

    protected void assertLengthLimit(String str, int limit, String name) {
        if (str != null) {
            this.assertSmallerLimit(str.length(), limit, name);
        }
    }

    protected void assertSmallerLimit(int num, int limit, String name) {
        if (num > limit) {
            throw new IllegalArgumentException(name + " over maximum size. yours length: " + num + ". It should shorter than " + limit);
        }
    }
}

