/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.CollectionUtils;
import org.shoulder.core.exception.BaseRuntimeException;
import org.shoulder.core.model.Operable;
import org.shoulder.core.util.StringUtils;
import org.shoulder.log.operation.enums.OperationResult;
import org.shoulder.log.operation.enums.TerminalType;
import org.shoulder.log.operation.model.OpLogParam;
import org.shoulder.log.operation.model.OperateResult;
import org.shoulder.log.operation.model.OperationDetailAble;
import org.shoulder.log.operation.model.Operator;

public class OperationLogDTO
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1998019128906395110L;
    protected String userId;
    protected String userName;
    protected String userRealName;
    protected String userOrgId;
    protected String userOrgName;
    protected TerminalType terminalType = TerminalType.UNKNOWN;
    protected String remoteAddress;
    protected String terminalId;
    protected String terminalInfo;
    protected String operation;
    protected Instant operationTime = Instant.now();
    protected Instant endTime;
    protected List<OpLogParam> params;
    protected String detail;
    protected String detailKey;
    protected List<String> detailItems;
    protected OperationResult result = OperationResult.SUCCESS;
    protected String errorCode;
    protected String objectType;
    protected String objectId;
    protected String objectName;
    protected String businessId;
    protected String tenantCode;
    protected String appId;
    protected Long instanceId;
    protected String traceId;
    protected Map<String, Object> extFields;

    public OperationLogDTO() {
    }

    public OperationLogDTO(String operation) {
        this.operation = operation;
    }

    @JsonIgnore
    public OperationLogDTO setOperator(Operator operator) {
        if (operator != null) {
            this.userId = operator.getUserId();
            this.userName = operator.getUserName();
            this.userRealName = operator.getUserRealName();
            this.userOrgId = operator.getUserOrgId();
            this.userOrgName = operator.getUserOrgName();
            this.remoteAddress = operator.getRemoteAddress();
            this.terminalType = operator.getTerminalType();
            this.terminalId = operator.getTerminalId();
            this.terminalInfo = operator.getTerminalInfo();
        }
        return this;
    }

    @JsonIgnore
    public OperationLogDTO setOperableObject(Operable operable) {
        if (operable != null) {
            this.objectId = operable.getObjectId();
            this.objectName = operable.getObjectName();
            this.objectType = operable.getObjectType();
            if (operable instanceof OperationDetailAble) {
                OperationDetailAble operationDetailAble = (OperationDetailAble)operable;
                if (CollectionUtils.isNotEmpty(operationDetailAble.getDetailItems())) {
                    this.detailItems = operationDetailAble.getDetailItems();
                }
                if (StringUtils.isNotEmpty((CharSequence)operationDetailAble.getDetailKey())) {
                    this.detailKey = operationDetailAble.getDetailKey();
                }
                if (StringUtils.isNotEmpty((CharSequence)operationDetailAble.getDetail())) {
                    this.detail = operationDetailAble.getDetail();
                }
            }
            if (operable instanceof OperateResult) {
                this.setResult(OperationResult.of(((OperateResult)operable).success()));
            }
        }
        return this;
    }

    public OperationLogDTO addDetailItem(String detailItem) {
        if (detailItem != null) {
            if (this.detailItems == null) {
                this.detailItems = new LinkedList<String>();
            }
            this.detailItems.add(detailItem);
        }
        return this;
    }

    @JsonIgnore
    public OperationLogDTO setExtField(String extKey, Object value) {
        if (extKey == null) {
            return this;
        }
        if (this.extFields == null) {
            this.extFields = new LinkedHashMap<String, Object>();
        }
        this.extFields.put(extKey, value);
        return this;
    }

    @JsonIgnore
    public <T> T getExtField(String extKey) {
        if (extKey == null || this.extFields == null) {
            return null;
        }
        return (T)this.extFields.get(extKey);
    }

    @JsonIgnore
    public OperationLogDTO setResultFail() {
        return this.setResult(OperationResult.FAIL);
    }

    public OperationLogDTO clone() {
        try {
            super.clone();
            return this.cloneTo(new OperationLogDTO());
        }
        catch (CloneNotSupportedException e) {
            throw new BaseRuntimeException((Throwable)e);
        }
    }

    public OperationLogDTO cloneTo(@Nonnull OperationLogDTO clone) {
        clone.setUserId(this.userId);
        clone.setUserName(this.userName);
        clone.setUserRealName(this.userRealName);
        clone.setUserOrgId(this.userOrgId);
        clone.setTerminalType(this.terminalType);
        clone.setRemoteAddress(this.remoteAddress);
        clone.setTerminalId(this.terminalId);
        clone.setTerminalInfo(this.terminalInfo);
        clone.setObjectId(this.objectId);
        clone.setObjectType(this.objectType);
        clone.setObjectName(this.objectName);
        clone.setOperation(this.operation);
        clone.setParams(this.params);
        clone.setOperationTime(this.operationTime);
        clone.setEndTime(this.endTime);
        clone.setResult(this.result);
        clone.setDetailKey(this.detailKey);
        if (this.detailItems != null) {
            clone.setDetailItems(new LinkedList<String>(this.detailItems));
        }
        clone.setDetail(this.detail);
        clone.setErrorCode(this.errorCode);
        clone.setTenantCode(this.tenantCode);
        clone.setAppId(this.appId);
        clone.setInstanceId(this.instanceId);
        clone.setTraceId(this.traceId);
        clone.setBusinessId(this.businessId);
        clone.setExtFields(this.extFields);
        return clone;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserRealName() {
        return this.userRealName;
    }

    public String getUserOrgId() {
        return this.userOrgId;
    }

    public String getUserOrgName() {
        return this.userOrgName;
    }

    public TerminalType getTerminalType() {
        return this.terminalType;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public String getTerminalInfo() {
        return this.terminalInfo;
    }

    public String getOperation() {
        return this.operation;
    }

    public Instant getOperationTime() {
        return this.operationTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public List<OpLogParam> getParams() {
        return this.params;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getDetailKey() {
        return this.detailKey;
    }

    public List<String> getDetailItems() {
        return this.detailItems;
    }

    public OperationResult getResult() {
        return this.result;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getTenantCode() {
        return this.tenantCode;
    }

    public String getAppId() {
        return this.appId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getExtFields() {
        return this.extFields;
    }

    public OperationLogDTO setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public OperationLogDTO setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public OperationLogDTO setUserRealName(String userRealName) {
        this.userRealName = userRealName;
        return this;
    }

    public OperationLogDTO setUserOrgId(String userOrgId) {
        this.userOrgId = userOrgId;
        return this;
    }

    public OperationLogDTO setUserOrgName(String userOrgName) {
        this.userOrgName = userOrgName;
        return this;
    }

    public OperationLogDTO setTerminalType(TerminalType terminalType) {
        this.terminalType = terminalType;
        return this;
    }

    public OperationLogDTO setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public OperationLogDTO setTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    public OperationLogDTO setTerminalInfo(String terminalInfo) {
        this.terminalInfo = terminalInfo;
        return this;
    }

    public OperationLogDTO setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public OperationLogDTO setOperationTime(Instant operationTime) {
        this.operationTime = operationTime;
        return this;
    }

    public OperationLogDTO setEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public OperationLogDTO setParams(List<OpLogParam> params) {
        this.params = params;
        return this;
    }

    public OperationLogDTO setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public OperationLogDTO setDetailKey(String detailKey) {
        this.detailKey = detailKey;
        return this;
    }

    public OperationLogDTO setDetailItems(List<String> detailItems) {
        this.detailItems = detailItems;
        return this;
    }

    public OperationLogDTO setResult(OperationResult result) {
        this.result = result;
        return this;
    }

    public OperationLogDTO setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public OperationLogDTO setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public OperationLogDTO setObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    public OperationLogDTO setObjectName(String objectName) {
        this.objectName = objectName;
        return this;
    }

    public OperationLogDTO setBusinessId(String businessId) {
        this.businessId = businessId;
        return this;
    }

    public OperationLogDTO setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
        return this;
    }

    public OperationLogDTO setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public OperationLogDTO setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public OperationLogDTO setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public OperationLogDTO setExtFields(Map<String, Object> extFields) {
        this.extFields = extFields;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationLogDTO)) {
            return false;
        }
        OperationLogDTO other = (OperationLogDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$instanceId = this.getInstanceId();
        Long other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$userRealName = this.getUserRealName();
        String other$userRealName = other.getUserRealName();
        if (this$userRealName == null ? other$userRealName != null : !this$userRealName.equals(other$userRealName)) {
            return false;
        }
        String this$userOrgId = this.getUserOrgId();
        String other$userOrgId = other.getUserOrgId();
        if (this$userOrgId == null ? other$userOrgId != null : !this$userOrgId.equals(other$userOrgId)) {
            return false;
        }
        String this$userOrgName = this.getUserOrgName();
        String other$userOrgName = other.getUserOrgName();
        if (this$userOrgName == null ? other$userOrgName != null : !this$userOrgName.equals(other$userOrgName)) {
            return false;
        }
        TerminalType this$terminalType = this.getTerminalType();
        TerminalType other$terminalType = other.getTerminalType();
        if (this$terminalType == null ? other$terminalType != null : !((Object)((Object)this$terminalType)).equals((Object)other$terminalType)) {
            return false;
        }
        String this$remoteAddress = this.getRemoteAddress();
        String other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
            return false;
        }
        String this$terminalId = this.getTerminalId();
        String other$terminalId = other.getTerminalId();
        if (this$terminalId == null ? other$terminalId != null : !this$terminalId.equals(other$terminalId)) {
            return false;
        }
        String this$terminalInfo = this.getTerminalInfo();
        String other$terminalInfo = other.getTerminalInfo();
        if (this$terminalInfo == null ? other$terminalInfo != null : !this$terminalInfo.equals(other$terminalInfo)) {
            return false;
        }
        String this$operation = this.getOperation();
        String other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        Instant this$operationTime = this.getOperationTime();
        Instant other$operationTime = other.getOperationTime();
        if (this$operationTime == null ? other$operationTime != null : !((Object)this$operationTime).equals(other$operationTime)) {
            return false;
        }
        Instant this$endTime = this.getEndTime();
        Instant other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<OpLogParam> this$params = this.getParams();
        List<OpLogParam> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        String this$detailKey = this.getDetailKey();
        String other$detailKey = other.getDetailKey();
        if (this$detailKey == null ? other$detailKey != null : !this$detailKey.equals(other$detailKey)) {
            return false;
        }
        List<String> this$detailItems = this.getDetailItems();
        List<String> other$detailItems = other.getDetailItems();
        if (this$detailItems == null ? other$detailItems != null : !((Object)this$detailItems).equals(other$detailItems)) {
            return false;
        }
        OperationResult this$result = this.getResult();
        OperationResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$objectType = this.getObjectType();
        String other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        String this$businessId = this.getBusinessId();
        String other$businessId = other.getBusinessId();
        if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Map<String, Object> this$extFields = this.getExtFields();
        Map<String, Object> other$extFields = other.getExtFields();
        return !(this$extFields == null ? other$extFields != null : !((Object)this$extFields).equals(other$extFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperationLogDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $userRealName = this.getUserRealName();
        result = result * 59 + ($userRealName == null ? 43 : $userRealName.hashCode());
        String $userOrgId = this.getUserOrgId();
        result = result * 59 + ($userOrgId == null ? 43 : $userOrgId.hashCode());
        String $userOrgName = this.getUserOrgName();
        result = result * 59 + ($userOrgName == null ? 43 : $userOrgName.hashCode());
        TerminalType $terminalType = this.getTerminalType();
        result = result * 59 + ($terminalType == null ? 43 : ((Object)((Object)$terminalType)).hashCode());
        String $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        String $terminalId = this.getTerminalId();
        result = result * 59 + ($terminalId == null ? 43 : $terminalId.hashCode());
        String $terminalInfo = this.getTerminalInfo();
        result = result * 59 + ($terminalInfo == null ? 43 : $terminalInfo.hashCode());
        String $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        Instant $operationTime = this.getOperationTime();
        result = result * 59 + ($operationTime == null ? 43 : ((Object)$operationTime).hashCode());
        Instant $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<OpLogParam> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        String $detailKey = this.getDetailKey();
        result = result * 59 + ($detailKey == null ? 43 : $detailKey.hashCode());
        List<String> $detailItems = this.getDetailItems();
        result = result * 59 + ($detailItems == null ? 43 : ((Object)$detailItems).hashCode());
        OperationResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        String $businessId = this.getBusinessId();
        result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Map<String, Object> $extFields = this.getExtFields();
        result = result * 59 + ($extFields == null ? 43 : ((Object)$extFields).hashCode());
        return result;
    }

    public String toString() {
        return "OperationLogDTO(userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", userRealName=" + this.getUserRealName() + ", userOrgId=" + this.getUserOrgId() + ", userOrgName=" + this.getUserOrgName() + ", terminalType=" + String.valueOf((Object)this.getTerminalType()) + ", remoteAddress=" + this.getRemoteAddress() + ", terminalId=" + this.getTerminalId() + ", terminalInfo=" + this.getTerminalInfo() + ", operation=" + this.getOperation() + ", operationTime=" + String.valueOf(this.getOperationTime()) + ", endTime=" + String.valueOf(this.getEndTime()) + ", params=" + String.valueOf(this.getParams()) + ", detail=" + this.getDetail() + ", detailKey=" + this.getDetailKey() + ", detailItems=" + String.valueOf(this.getDetailItems()) + ", result=" + String.valueOf((Object)this.getResult()) + ", errorCode=" + this.getErrorCode() + ", objectType=" + this.getObjectType() + ", objectId=" + this.getObjectId() + ", objectName=" + this.getObjectName() + ", businessId=" + this.getBusinessId() + ", tenantCode=" + this.getTenantCode() + ", appId=" + this.getAppId() + ", instanceId=" + this.getInstanceId() + ", traceId=" + this.getTraceId() + ", extFields=" + String.valueOf(this.getExtFields()) + ")";
    }
}

