/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.model;

import java.io.Serializable;
import org.shoulder.log.operation.enums.TerminalType;
import org.shoulder.log.operation.model.Operator;

public class ShoulderCurrentUserOperator
implements Serializable,
Operator {
    private static final long serialVersionUID = 1429478242021042150L;
    protected String userId;
    protected String userRealName;
    protected String remoteAddress;
    protected TerminalType terminalType = TerminalType.UNKNOWN;
    protected String terminalId;
    protected String terminalInfo;

    public ShoulderCurrentUserOperator(String userId) {
        this.userId = userId;
    }

    public ShoulderCurrentUserOperator(Operator operator) {
        this.userId = operator.getUserId();
        this.userRealName = operator.getUserName();
        this.userRealName = operator.getUserRealName();
        this.remoteAddress = operator.getRemoteAddress();
        this.terminalId = operator.getTerminalId();
        this.terminalInfo = operator.getTerminalInfo();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getUserRealName() {
        return this.userRealName;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public TerminalType getTerminalType() {
        return this.terminalType;
    }

    @Override
    public String getTerminalId() {
        return this.terminalId;
    }

    @Override
    public String getTerminalInfo() {
        return this.terminalInfo;
    }

    public ShoulderCurrentUserOperator setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public ShoulderCurrentUserOperator setUserRealName(String userRealName) {
        this.userRealName = userRealName;
        return this;
    }

    public ShoulderCurrentUserOperator setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public ShoulderCurrentUserOperator setTerminalType(TerminalType terminalType) {
        this.terminalType = terminalType;
        return this;
    }

    public ShoulderCurrentUserOperator setTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    public ShoulderCurrentUserOperator setTerminalInfo(String terminalInfo) {
        this.terminalInfo = terminalInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShoulderCurrentUserOperator)) {
            return false;
        }
        ShoulderCurrentUserOperator other = (ShoulderCurrentUserOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userRealName = this.getUserRealName();
        String other$userRealName = other.getUserRealName();
        if (this$userRealName == null ? other$userRealName != null : !this$userRealName.equals(other$userRealName)) {
            return false;
        }
        String this$remoteAddress = this.getRemoteAddress();
        String other$remoteAddress = other.getRemoteAddress();
        if (this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress)) {
            return false;
        }
        TerminalType this$terminalType = this.getTerminalType();
        TerminalType other$terminalType = other.getTerminalType();
        if (this$terminalType == null ? other$terminalType != null : !((Object)((Object)this$terminalType)).equals((Object)other$terminalType)) {
            return false;
        }
        String this$terminalId = this.getTerminalId();
        String other$terminalId = other.getTerminalId();
        if (this$terminalId == null ? other$terminalId != null : !this$terminalId.equals(other$terminalId)) {
            return false;
        }
        String this$terminalInfo = this.getTerminalInfo();
        String other$terminalInfo = other.getTerminalInfo();
        return !(this$terminalInfo == null ? other$terminalInfo != null : !this$terminalInfo.equals(other$terminalInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShoulderCurrentUserOperator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userRealName = this.getUserRealName();
        result = result * 59 + ($userRealName == null ? 43 : $userRealName.hashCode());
        String $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        TerminalType $terminalType = this.getTerminalType();
        result = result * 59 + ($terminalType == null ? 43 : ((Object)((Object)$terminalType)).hashCode());
        String $terminalId = this.getTerminalId();
        result = result * 59 + ($terminalId == null ? 43 : $terminalId.hashCode());
        String $terminalInfo = this.getTerminalInfo();
        result = result * 59 + ($terminalInfo == null ? 43 : $terminalInfo.hashCode());
        return result;
    }

    public String toString() {
        return "ShoulderCurrentUserOperator(userId=" + this.getUserId() + ", userRealName=" + this.getUserRealName() + ", remoteAddress=" + this.getRemoteAddress() + ", terminalType=" + String.valueOf((Object)this.getTerminalType()) + ", terminalId=" + this.getTerminalId() + ", terminalInfo=" + this.getTerminalInfo() + ")";
    }

    public ShoulderCurrentUserOperator() {
    }

    public ShoulderCurrentUserOperator(String userId, String userRealName, String remoteAddress, TerminalType terminalType, String terminalId, String terminalInfo) {
        this.userId = userId;
        this.userRealName = userRealName;
        this.remoteAddress = remoteAddress;
        this.terminalType = terminalType;
        this.terminalId = terminalId;
        this.terminalInfo = terminalInfo;
    }
}

