/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.model;

import javax.annotation.Nonnull;
import org.shoulder.core.context.AppInfo;
import org.shoulder.core.util.AddressUtils;
import org.shoulder.log.operation.enums.TerminalType;
import org.shoulder.log.operation.model.Operator;

public class SystemOperator
implements Operator {
    private final String systemUserId;
    private final String hostAddress;
    private final String mac;

    private SystemOperator(String systemUserId, String hostAddress, String mac) {
        this.systemUserId = systemUserId;
        this.hostAddress = hostAddress;
        this.mac = mac;
    }

    public static SystemOperator getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    @Nonnull
    public String getUserId() {
        return this.systemUserId;
    }

    @Override
    public String getRemoteAddress() {
        return this.hostAddress;
    }

    @Override
    public String getUserName() {
        return "_system_";
    }

    @Override
    @Nonnull
    public TerminalType getTerminalType() {
        return TerminalType.SYSTEM;
    }

    @Override
    public String getTerminalId() {
        return this.mac;
    }

    private static class SingletonHolder {
        private static final SystemOperator INSTANCE = new SystemOperator("system." + AppInfo.appId() + "." + AppInfo.instanceId(), AddressUtils.getIp(), AddressUtils.getMac());

        private SingletonHolder() {
        }
    }
}

