/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.model.sample;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.core.model.Operable;
import org.shoulder.log.operation.model.sample.OperableObject;

public class MultiOperableDecorator
extends OperableObject {
    private static final String ELLIPSIS = "...";

    public MultiOperableDecorator(Collection<? extends Operable> logObjects) {
        if (logObjects == null || logObjects.isEmpty()) {
            return;
        }
        Operable logObject = logObjects.stream().findFirst().get();
        if (logObjects.size() == 1) {
            this.objectId = logObject.getObjectId();
            this.objectName = logObject.getObjectName();
            this.objectType = logObject.getObjectType();
        } else {
            StringBuilder objectsName = new StringBuilder();
            StringBuilder objectsId = new StringBuilder();
            for (Operable operable : logObjects) {
                if (StringUtils.isNotEmpty((CharSequence)operable.getObjectId())) {
                    objectsId.append(operable.getObjectId()).append(",");
                }
                if (!StringUtils.isNotEmpty((CharSequence)operable.getObjectName())) continue;
                objectsName.append(operable.getObjectName()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)objectsId)) {
                objectsId.deleteCharAt(objectsId.length() - 1);
            }
            if (StringUtils.isNotEmpty((CharSequence)objectsName)) {
                objectsName.deleteCharAt(objectsName.length() - 1);
            }
            int idMaxLength = 127;
            int n = 255;
            if (objectsId.length() > idMaxLength) {
                objectsId.delete(idMaxLength - 3, objectsId.length()).append(ELLIPSIS);
            }
            if (objectsName.length() > n) {
                objectsName.delete(n - 3, objectsName.length()).append(ELLIPSIS);
            }
            this.objectId = objectsId.toString();
            this.objectName = objectsName.toString();
            this.objectType = logObject.getObjectType();
        }
    }
}

