/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.log.operation.support;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.shoulder.log.operation.support.OperableObjectTypeRepository;

public class HashMapOperableObjectTypeRepository
implements OperableObjectTypeRepository {
    private static final ConcurrentMap<Class<?>, String> CACHE = new ConcurrentHashMap();
    private final Function<Class<?>, String> defaultTypeCalculator;

    public HashMapOperableObjectTypeRepository(Function<Class<?>, String> defaultTypeCalculator) {
        this.defaultTypeCalculator = defaultTypeCalculator;
    }

    @Override
    public String getObjectType(Class<?> operableClass) {
        return this.getObjectType(operableClass, this.defaultTypeCalculator);
    }

    @Override
    public String getObjectType(Class<?> operableClass, Function<Class<?>, String> defaultTypeCalculator) {
        return CACHE.computeIfAbsent(operableClass, defaultTypeCalculator);
    }
}

