/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.jany.p6spy;

import com.p6spy.engine.common.Value;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

class DelegateValue
extends Value {
    private final String url;
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss";

    public DelegateValue(Value value, String url) {
        super(value.getValue());
        this.url = url;
    }

    public String convertToString(Object value) {
        if (value instanceof Timestamp) {
            if (this.url == null) {
                return super.convertToString(value);
            }
            if (this.url.contains(":h2:")) {
                String val = new SimpleDateFormat(PATTERN).format(value);
                return String.format("parsedatetime('%s', 'yyyy-MM-dd HH:mm:ss')", val);
            }
            if (this.url.contains(":postgresql:") || this.url.contains(":pgsql:")) {
                String val = new SimpleDateFormat(PATTERN).format(value);
                return String.format("to_timestamp('%s', 'yyyy-mm-dd hh24:mi:ss')", val);
            }
            if (this.url.contains(":mysql:") || this.url.contains(":mariadb:")) {
                String val = new SimpleDateFormat(PATTERN).format(value);
                return "str_to_date('" + val + "','%Y-%m-%d %H:%i:%s')";
            }
            if (this.url.contains(":oracle:")) {
                String val = new SimpleDateFormat(PATTERN).format(value);
                return "to_date('" + val + "','yyyy-mm-dd hh24:mi:ss')";
            }
        }
        return super.convertToString(value);
    }
}

