package jexx.io;

import jexx.util.Assert;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;

public class InputStreamResource implements Resource{

    private final InputStream inputStream;
    private boolean read = false;
    private boolean buffered = false;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, checkBuffered(inputStream));
    }

    public InputStreamResource(InputStream inputStream, boolean buffered) {
        this.inputStream = inputStream;
        this.buffered = buffered;
    }

    @Override
    public boolean isBuffered() {
        return buffered;
    }

    @Override
    public InputStream getInputStream() {
        Assert.isFalse(read, "inputStream has already been read");
        read = true;
        return this.inputStream;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getFilename() {
        return null;
    }

    public static boolean checkBuffered(InputStream inputStream){
        return BufferedInputStream.class.isAssignableFrom(inputStream.getClass());
    }

}
