/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.common.model.cross;

import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class CrossBlacklist
implements IModel {
    private static String APP_KEY = "appkey";
    private static String USERNAMES = "usernames";
    private Gson gson = new Gson();
    private String appKey;
    private String[] users;

    private CrossBlacklist(String appKey, String[] users) {
        this.appKey = appKey;
        this.users = users;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.appKey) {
            json.addProperty(APP_KEY, this.appKey);
        }
        if (null != this.users) {
            JsonArray array = new JsonArray();
            for (String user : this.users) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            json.add(USERNAMES, (JsonElement)array);
        }
        return json;
    }

    public String toString() {
        return this.gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String appKey;
        private String[] users;

        public Builder setAppKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder addUsers(String ... users) {
            this.users = users;
            return this;
        }

        public CrossBlacklist build() {
            Preconditions.checkArgument((null != this.appKey ? 1 : 0) != 0, (Object)"AppKey must not be null");
            Preconditions.checkArgument((null != this.users ? 1 : 0) != 0, (Object)"At least add one user");
            return new CrossBlacklist(this.appKey, this.users);
        }
    }
}

