/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.crossapp;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.cross.CrossBlacklist;
import cn.jmessage.api.common.model.cross.CrossBlacklistPayload;
import cn.jmessage.api.common.model.cross.CrossFriendPayload;
import cn.jmessage.api.common.model.cross.CrossGroup;
import cn.jmessage.api.common.model.cross.CrossGroupPayload;
import cn.jmessage.api.common.model.cross.CrossNoDisturb;
import cn.jmessage.api.common.model.cross.CrossNoDisturbPayload;
import cn.jmessage.api.group.MemberListResult;
import cn.jmessage.api.user.UserInfoResult;
import cn.jmessage.api.utils.StringUtils;

public class CrossAppClient
extends BaseClient {
    private String crossUserPath;
    private String crossGroupPath;

    public CrossAppClient(String appkey, String masterSecret) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance());
    }

    public CrossAppClient(String appKey, String masterSecret, HttpProxy proxy) {
        this(appKey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public CrossAppClient(String appKey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appKey, masterSecret, proxy, config);
        this.crossUserPath = (String)config.get("im.cross.user.path");
        this.crossGroupPath = (String)config.get("im.cross.group.path");
    }

    public ResponseWrapper addOrRemoveCrossGroupMembers(long gid, CrossGroup[] groups) throws APIConnectionException, APIRequestException {
        CrossGroupPayload payload = new CrossGroupPayload.Builder().setCrossGroups(groups).build();
        Preconditions.checkArgument((0L != gid ? 1 : 0) != 0, (Object)"gid should not be empty");
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"CrossGroup must not be null");
        return this._httpClient.sendPost(this._baseUrl + this.crossGroupPath + "/" + gid + "/members", payload.toString());
    }

    public MemberListResult getCrossGroupMembers(long gid) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((0L != gid ? 1 : 0) != 0, (Object)"gid must not be empty");
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.crossGroupPath + "/" + gid + "/members/");
        return MemberListResult.fromResponse(response);
    }

    public ResponseWrapper addCrossBlacklist(String username, CrossBlacklist[] blacklists) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        CrossBlacklistPayload payload = new CrossBlacklistPayload.Builder().setCrossBlacklists(blacklists).build();
        return this._httpClient.sendPut(this._baseUrl + this.crossUserPath + "/" + username + "/blacklist", payload.toString());
    }

    public ResponseWrapper deleteCrossBlacklist(String username, CrossBlacklist[] blacklists) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        CrossBlacklistPayload payload = new CrossBlacklistPayload.Builder().setCrossBlacklists(blacklists).build();
        return this._httpClient.sendDelete(this._baseUrl + this.crossUserPath + "/" + username + "/blacklist", payload.toString());
    }

    public UserInfoResult[] getCrossBlacklist(String username) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.crossUserPath + "/" + username + "/blacklist");
        return (UserInfoResult[])this._gson.fromJson(response.responseContent, UserInfoResult[].class);
    }

    public ResponseWrapper setCrossNoDisturb(String username, CrossNoDisturb[] array) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        CrossNoDisturbPayload payload = new CrossNoDisturbPayload.Builder().setCrossNoDistrub(array).build();
        return this._httpClient.sendPost(this._baseUrl + this.crossUserPath + "/" + username + "/nodisturb", payload.toString());
    }

    public ResponseWrapper addCrossFriends(String username, CrossFriendPayload payload) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"CrossFriendPayload should not be null");
        return this._httpClient.sendPost(this._baseUrl + this.crossUserPath + "/" + username + "/friends", payload.toString());
    }

    public ResponseWrapper deleteCrossFriends(String username, CrossFriendPayload payload) throws APIConnectionException, APIRequestException {
        StringUtils.checkUsername(username);
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"CrossFriendPayload should not be null");
        return this._httpClient.sendDelete(this._baseUrl + this.crossUserPath + "/" + username + "/friends", payload.toString());
    }
}

