/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.api.group;

import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jmessage.api.common.BaseClient;
import cn.jmessage.api.common.JMessageConfig;
import cn.jmessage.api.common.model.Members;
import cn.jmessage.api.common.model.group.GroupPayload;
import cn.jmessage.api.group.CreateGroupResult;
import cn.jmessage.api.group.GroupInfoResult;
import cn.jmessage.api.group.GroupListResult;
import cn.jmessage.api.group.MemberListResult;
import cn.jmessage.api.utils.StringUtils;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupClient
extends BaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(GroupClient.class);
    private String groupPath;

    public GroupClient(String appkey, String masterSecret) {
        this(appkey, masterSecret, null, JMessageConfig.getInstance());
    }

    public GroupClient(String appkey, String masterSecret, HttpProxy proxy) {
        this(appkey, masterSecret, proxy, JMessageConfig.getInstance());
    }

    public GroupClient(String appkey, String masterSecret, HttpProxy proxy, JMessageConfig config) {
        super(appkey, masterSecret, proxy, config);
        this.groupPath = (String)config.get("im.group.path");
    }

    public GroupInfoResult getGroupInfo(long gid) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.groupPath + "/" + gid);
        return (GroupInfoResult)GroupInfoResult.fromResponse((ResponseWrapper)response, GroupInfoResult.class);
    }

    public MemberListResult getGroupMembers(long gid) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.groupPath + "/" + gid + "/members");
        return MemberListResult.fromResponse(response);
    }

    public GroupListResult getGroupListByAppkey(int start, int count) throws APIConnectionException, APIRequestException {
        if (start < 0 || count <= 0 || count > 500) {
            throw new IllegalArgumentException("negative index or count must more than 0 and less than 501");
        }
        ResponseWrapper response = this._httpClient.sendGet(this._baseUrl + this.groupPath + "?start=" + start + "&count=" + count);
        return (GroupListResult)GroupListResult.fromResponse((ResponseWrapper)response, GroupListResult.class);
    }

    public CreateGroupResult createGroup(GroupPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"group payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this.groupPath, payload.toString());
        return (CreateGroupResult)CreateGroupResult.fromResponse((ResponseWrapper)response, CreateGroupResult.class);
    }

    public ResponseWrapper addOrRemoveMembers(long gid, Members add, Members remove) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        if (null == add && null == remove) {
            Preconditions.checkArgument((boolean)false, (Object)"add list or remove list should not be null at the same time.");
        }
        JsonObject json = new JsonObject();
        if (null != add) {
            json.add("add", add.toJSON());
        }
        if (null != remove) {
            json.add("remove", remove.toJSON());
        }
        return this._httpClient.sendPost(this._baseUrl + this.groupPath + "/" + gid + "/members", json.toString());
    }

    public ResponseWrapper deleteGroup(long gid) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        return this._httpClient.sendDelete(this._baseUrl + this.groupPath + "/" + gid);
    }

    public ResponseWrapper updateGroupInfo(long gid, String groupName, String groupDesc, String avatar) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        if (StringUtils.isTrimedEmpty(groupName) && StringUtils.isTrimedEmpty(groupDesc) && StringUtils.isTrimedEmpty(avatar)) {
            Preconditions.checkArgument((boolean)false, (Object)"group name, group description and group avatar should not be null at the same time.");
        }
        JsonObject json = new JsonObject();
        if (StringUtils.isNotEmpty(groupName)) {
            Preconditions.checkArgument(((groupName = groupName.trim()).getBytes().length <= 64 ? 1 : 0) != 0, (Object)"The length of group name must not more than 64 bytes.");
            Preconditions.checkArgument((!StringUtils.isLineBroken(groupName) ? 1 : 0) != 0, (Object)"The group name must not contain line feed character.");
            json.addProperty("name", groupName);
        }
        if (StringUtils.isNotEmpty(groupDesc)) {
            Preconditions.checkArgument(((groupDesc = groupDesc.trim()).getBytes().length <= 250 ? 1 : 0) != 0, (Object)"The length of group description must not more than 250 bytes.");
            json.addProperty("desc", groupDesc);
        }
        if (StringUtils.isNotEmpty(avatar)) {
            avatar = avatar.trim();
            json.addProperty("avatar", avatar);
        }
        return this._httpClient.sendPut(this._baseUrl + this.groupPath + "/" + gid, json.toString());
    }

    public ResponseWrapper changeGroupAdmin(long gid, String appKey, String username) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((gid > 0L ? 1 : 0) != 0, (Object)"gid should more than 0.");
        if (StringUtils.isTrimedEmpty(appKey) && StringUtils.isTrimedEmpty(username)) {
            Preconditions.checkArgument((boolean)false, (Object)"appKey and username should not be null at the same time.");
        }
        JsonObject json = new JsonObject();
        if (StringUtils.isNotEmpty(appKey)) {
            appKey = appKey.trim();
            json.addProperty("appKey", appKey);
        }
        if (StringUtils.isNotEmpty(username)) {
            username = username.trim();
            json.addProperty("username", username);
        }
        return this._httpClient.sendPut(this._baseUrl + this.groupPath + "/owner/" + gid, json.toString());
    }
}

