/*
 * Decompiled with CFR 0.152.
 */
package cn.jzvd;

import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import cn.jzvd.JZMediaInterface;
import cn.jzvd.JZMediaManager;
import cn.jzvd.JzvdMgr;
import java.lang.reflect.Method;
import java.util.Map;

public class JZMediaSystem
extends JZMediaInterface
implements MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    public MediaPlayer mediaPlayer;

    @Override
    public void start() {
        this.mediaPlayer.start();
    }

    @Override
    public void prepare() {
        try {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setLooping(this.jzDataSource.looping);
            this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.mediaPlayer.setScreenOnWhilePlaying(true);
            this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
            this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            Class<MediaPlayer> clazz = MediaPlayer.class;
            Method method = clazz.getDeclaredMethod("setDataSource", String.class, Map.class);
            method.invoke((Object)this.mediaPlayer, this.jzDataSource.getCurrentUrl().toString(), this.jzDataSource.headerMap);
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pause() {
        this.mediaPlayer.pause();
    }

    @Override
    public boolean isPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        try {
            this.mediaPlayer.seekTo((int)time);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void setSurface(Surface surface) {
        this.mediaPlayer.setSurface(surface);
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        this.mediaPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    @RequiresApi(api=23)
    public void setSpeed(float speed) {
        PlaybackParams pp = this.mediaPlayer.getPlaybackParams();
        pp.setSpeed(speed);
        this.mediaPlayer.setPlaybackParams(pp);
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        mediaPlayer.start();
        if (this.jzDataSource.getCurrentUrl().toString().toLowerCase().contains("mp3") || this.jzDataSource.getCurrentUrl().toString().toLowerCase().contains("wav")) {
            JZMediaManager.instance().mainThreadHandler.post(() -> {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    JzvdMgr.getCurrentJzvd().onPrepared();
                }
            });
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                JzvdMgr.getCurrentJzvd().onAutoCompletion();
            }
        });
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                JzvdMgr.getCurrentJzvd().setBufferProgress(percent);
            }
        });
    }

    public void onSeekComplete(MediaPlayer mediaPlayer) {
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                JzvdMgr.getCurrentJzvd().onSeekComplete();
            }
        });
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                JzvdMgr.getCurrentJzvd().onError(what, extra);
            }
        });
        return true;
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int what, int extra) {
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                if (what == 3) {
                    if (JzvdMgr.getCurrentJzvd().currentState == 1 || JzvdMgr.getCurrentJzvd().currentState == 2) {
                        JzvdMgr.getCurrentJzvd().onPrepared();
                    }
                } else {
                    JzvdMgr.getCurrentJzvd().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
        JZMediaManager.instance().currentVideoWidth = width;
        JZMediaManager.instance().currentVideoHeight = height;
        JZMediaManager.instance().mainThreadHandler.post(() -> {
            if (JzvdMgr.getCurrentJzvd() != null) {
                JzvdMgr.getCurrentJzvd().onVideoSizeChanged();
            }
        });
    }
}

