/*
 * Decompiled with CFR 0.152.
 */
package cn.lesper.handler;

import cn.lesper.exceptions.Excel4JException;
import cn.lesper.handler.SheetTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class SheetTemplateHandler {
    public static SheetTemplate sheetTemplateBuilder(String templatePath) throws Excel4JException {
        SheetTemplate sheetTemplate = new SheetTemplate();
        try {
            sheetTemplate.workbook = WorkbookFactory.create((InputStream)new FileInputStream(new File(templatePath)));
        }
        catch (Exception e) {
            try {
                sheetTemplate.workbook = WorkbookFactory.create((InputStream)SheetTemplateHandler.class.getResourceAsStream(templatePath));
            }
            catch (IOException | InvalidFormatException e1) {
                throw new Excel4JException(e1);
            }
        }
        return sheetTemplate;
    }

    public static SheetTemplate sheetTemplateBuilder(InputStream is) throws Excel4JException {
        SheetTemplate sheetTemplate = new SheetTemplate();
        try {
            sheetTemplate.workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (IOException | InvalidFormatException e) {
            throw new Excel4JException(e);
        }
        return sheetTemplate;
    }

    public static void loadTemplate(SheetTemplate template, int sheetIndex) {
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        template.sheetIndex = sheetIndex;
        template.sheet = template.workbook.getSheetAt(sheetIndex);
        SheetTemplateHandler.initModuleConfig(template);
        template.currentRowIndex = template.initRowIndex;
        template.currentColumnIndex = template.initColumnIndex;
        template.lastRowIndex = template.sheet.getLastRowNum();
    }

    private static void initModuleConfig(SheetTemplate template) {
        for (Row row : template.sheet) {
            for (Cell c : row) {
                if (c.getCellTypeEnum() != CellType.STRING) continue;
                String str = c.getStringCellValue().trim().toLowerCase();
                if ("$serial_number".equals(str)) {
                    template.serialNumberColumnIndex = c.getColumnIndex();
                }
                if ("$data_index".equals(str)) {
                    template.initColumnIndex = c.getColumnIndex();
                    template.initRowIndex = row.getRowNum();
                    template.rowHeight = row.getHeightInPoints();
                }
                SheetTemplateHandler.initStyles(template, c, str);
            }
        }
    }

    private static void initStyles(SheetTemplate template, Cell cell, String moduleContext) {
        if (null == moduleContext || "".equals(moduleContext)) {
            return;
        }
        if (!moduleContext.startsWith("&")) {
            moduleContext = moduleContext.toLowerCase();
        }
        if ("$default_style".equals(moduleContext)) {
            template.defaultStyle = cell.getCellStyle();
            SheetTemplateHandler.clearCell(cell);
        }
        if (moduleContext.startsWith("&") && moduleContext.length() > 1) {
            template.classifyStyle.put(moduleContext.substring(1), cell.getCellStyle());
            SheetTemplateHandler.clearCell(cell);
        }
        if ("$appoint_line_style".equals(moduleContext)) {
            template.appointLineStyle.put(cell.getRowIndex(), cell.getCellStyle());
            SheetTemplateHandler.clearCell(cell);
        }
        if ("$single_line_style".equals(moduleContext)) {
            template.singleLineStyle = cell.getCellStyle();
            SheetTemplateHandler.clearCell(cell);
        }
        if ("$double_line_style".equals(moduleContext)) {
            template.doubleLineStyle = cell.getCellStyle();
            SheetTemplateHandler.clearCell(cell);
        }
    }

    private static void clearCell(Cell cell) {
        cell.setCellStyle(null);
        cell.setCellValue("");
    }

    public static void extendData(SheetTemplate template, Map<String, String> data) {
        if (data == null) {
            return;
        }
        for (Row row : template.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellTypeEnum() != CellType.STRING || !(str = c.getStringCellValue().trim()).startsWith("#") || !data.containsKey(str.substring(1))) continue;
                c.setCellValue(data.get(str.substring(1)));
            }
        }
    }

    public static void createNewRow(SheetTemplate template) {
        if (template.lastRowIndex > template.currentRowIndex && template.currentRowIndex != template.initRowIndex) {
            template.sheet.shiftRows(template.currentRowIndex, template.lastRowIndex, 1, true, true);
            ++template.lastRowIndex;
        }
        template.currentRow = template.sheet.createRow(template.currentRowIndex);
        template.currentRow.setHeightInPoints(template.rowHeight);
        ++template.currentRowIndex;
        template.currentColumnIndex = template.initColumnIndex;
    }

    public static void insertSerial(SheetTemplate template, String styleKey) {
        if (template.serialNumberColumnIndex < 0) {
            return;
        }
        ++template.serialNumber;
        Cell c = template.currentRow.createCell(template.serialNumberColumnIndex);
        SheetTemplateHandler.setCellStyle(template, c, styleKey);
        c.setCellValue((double)template.serialNumber);
    }

    public static void createCell(SheetTemplate template, Object value, String styleKey) {
        Cell cell = template.currentRow.createCell(template.currentColumnIndex);
        SheetTemplateHandler.setCellStyle(template, cell, styleKey);
        if (null == value || "".equals(value)) {
            ++template.currentColumnIndex;
            return;
        }
        if (String.class == value.getClass()) {
            cell.setCellValue((String)value);
            ++template.currentColumnIndex;
            return;
        }
        if (Integer.TYPE == value.getClass()) {
            cell.setCellValue((double)((Integer)value).intValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Integer.class == value.getClass()) {
            cell.setCellValue((double)((Integer)value).intValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Double.TYPE == value.getClass()) {
            cell.setCellValue(((Double)value).doubleValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Double.class == value.getClass()) {
            cell.setCellValue(((Double)value).doubleValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Date.class == value.getClass()) {
            cell.setCellValue((Date)value);
            ++template.currentColumnIndex;
            return;
        }
        if (Boolean.TYPE == value.getClass()) {
            cell.setCellValue(((Boolean)value).booleanValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Boolean.class == value.getClass()) {
            cell.setCellValue(((Boolean)value).booleanValue());
            ++template.currentColumnIndex;
            return;
        }
        if (Calendar.class == value.getClass()) {
            cell.setCellValue((Calendar)value);
            ++template.currentColumnIndex;
            return;
        }
        ++template.currentColumnIndex;
    }

    private static void setCellStyle(SheetTemplate template, Cell cell, String styleKey) {
        if (null != styleKey && null != template.classifyStyle.get(styleKey)) {
            cell.setCellStyle(template.classifyStyle.get(styleKey));
            return;
        }
        if (null != template.appointLineStyle && template.appointLineStyle.containsKey(cell.getRowIndex())) {
            cell.setCellStyle(template.appointLineStyle.get(cell.getRowIndex()));
            return;
        }
        if (null != template.singleLineStyle && cell.getRowIndex() % 2 != 0) {
            cell.setCellStyle(template.singleLineStyle);
            return;
        }
        if (null != template.doubleLineStyle && cell.getRowIndex() % 2 == 0) {
            cell.setCellStyle(template.doubleLineStyle);
            return;
        }
        if (null != template.defaultStyle) {
            cell.setCellStyle(template.defaultStyle);
        }
    }
}

