/*
 * Decompiled with CFR 0.152.
 */
package cn.licoy.encryptbody.advice;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.RSA;
import cn.licoy.encryptbody.annotation.FieldBody;
import cn.licoy.encryptbody.annotation.encrypt.AESEncryptBody;
import cn.licoy.encryptbody.annotation.encrypt.DESEncryptBody;
import cn.licoy.encryptbody.annotation.encrypt.EncryptBody;
import cn.licoy.encryptbody.annotation.encrypt.MD5EncryptBody;
import cn.licoy.encryptbody.annotation.encrypt.RSAEncryptBody;
import cn.licoy.encryptbody.annotation.encrypt.SHAEncryptBody;
import cn.licoy.encryptbody.bean.EncryptAnnotationInfoBean;
import cn.licoy.encryptbody.config.EncryptBodyConfig;
import cn.licoy.encryptbody.enums.EncryptBodyMethod;
import cn.licoy.encryptbody.enums.SHAEncryptType;
import cn.licoy.encryptbody.exception.EncryptBodyFailException;
import cn.licoy.encryptbody.exception.EncryptMethodNotFoundException;
import cn.licoy.encryptbody.util.CommonUtils;
import cn.licoy.encryptbody.util.ShaEncryptUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);
    private final ObjectMapper objectMapper;
    private final EncryptBodyConfig config;

    @Autowired
    public EncryptResponseBodyAdvice(ObjectMapper objectMapper, EncryptBodyConfig config) {
        this.objectMapper = objectMapper;
        this.config = config;
    }

    public boolean supports(MethodParameter returnType, Class converterType) {
        Class declaringClass = returnType.getDeclaringClass();
        if (this.hasEncryptAnnotation(declaringClass)) {
            return true;
        }
        Method method = returnType.getMethod();
        if (method != null) {
            Class<?> returnValueType = method.getReturnType();
            return this.hasEncryptAnnotation(method) || this.hasEncryptAnnotation(returnValueType);
        }
        return false;
    }

    private boolean hasEncryptAnnotation(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return false;
        }
        return annotatedElement.isAnnotationPresent(EncryptBody.class) || annotatedElement.isAnnotationPresent(AESEncryptBody.class) || annotatedElement.isAnnotationPresent(DESEncryptBody.class) || annotatedElement.isAnnotationPresent(RSAEncryptBody.class) || annotatedElement.isAnnotationPresent(MD5EncryptBody.class) || annotatedElement.isAnnotationPresent(SHAEncryptBody.class);
    }

    public String beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        EncryptAnnotationInfoBean classAnnotation;
        if (body == null) {
            return null;
        }
        String str = CommonUtils.convertToStringOrJson(body, this.objectMapper);
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        Method method = returnType.getMethod();
        if (method != null) {
            EncryptAnnotationInfoBean methodAnnotation = this.getEncryptAnnotation(method);
            if (methodAnnotation != null) {
                return this.switchEncrypt(str, methodAnnotation);
            }
            Class<?> methodReturnType = method.getReturnType();
            if (methodReturnType.isAnnotationPresent(FieldBody.class)) {
                Object encryptResult = this.eachClassField(body, method.getReturnType());
                try {
                    return this.objectMapper.writeValueAsString(encryptResult);
                }
                catch (JsonProcessingException e) {
                    throw new EncryptBodyFailException(e.getMessage());
                }
            }
            EncryptAnnotationInfoBean returnTypeClassAnnotation = this.getEncryptAnnotation(methodReturnType);
            if (returnTypeClassAnnotation != null) {
                return this.switchEncrypt(str, returnTypeClassAnnotation);
            }
        }
        if ((classAnnotation = this.getEncryptAnnotation(returnType.getDeclaringClass())) != null) {
            return this.switchEncrypt(str, classAnnotation);
        }
        throw new EncryptBodyFailException();
    }

    private Object eachClassField(Object body, Class<?> returnTypeClass) {
        Field[] fields;
        for (Field field : fields = returnTypeClass.getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            Class<?> type = field.getType();
            EncryptAnnotationInfoBean encryptAnnotation = this.getEncryptAnnotation(field);
            if (encryptAnnotation != null) {
                Field setField;
                fieldValue = ReflectUtil.getFieldValue((Object)body, (Field)field);
                if (fieldValue == null) continue;
                String str = CommonUtils.convertToStringOrJson(fieldValue, this.objectMapper);
                String encryptResult = this.switchEncrypt(str, encryptAnnotation);
                if (type.equals(String.class)) {
                    ReflectUtil.setFieldValue((Object)body, (Field)field, (Object)encryptResult);
                    continue;
                }
                FieldBody fieldBody = field.getAnnotation(FieldBody.class);
                if (fieldBody == null || (setField = ReflectUtil.getField(returnTypeClass, (String)fieldBody.field())) == null || !setField.getType().equals(String.class)) continue;
                ReflectUtil.setFieldValue((Object)body, (String)fieldBody.field(), (Object)encryptResult);
                if (!fieldBody.clearValue()) continue;
                ReflectUtil.setFieldValue((Object)body, (Field)field, null);
                continue;
            }
            if (CommonUtils.isConvertToString(type) || (fieldValue = ReflectUtil.getFieldValue((Object)body, (Field)field)) == null) continue;
            this.eachClassField(fieldValue, type);
        }
        return body;
    }

    private EncryptAnnotationInfoBean getEncryptAnnotation(AnnotatedElement annotatedElement) {
        Annotation encryptBody;
        if (annotatedElement == null) {
            return null;
        }
        if (annotatedElement.isAnnotationPresent(EncryptBody.class) && (encryptBody = annotatedElement.getAnnotation(EncryptBody.class)) != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(encryptBody.value()).key(encryptBody.otherKey()).shaEncryptType(encryptBody.shaType()).build();
        }
        if (annotatedElement.isAnnotationPresent(MD5EncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.MD5).build();
        }
        if (annotatedElement.isAnnotationPresent(SHAEncryptBody.class) && (encryptBody = annotatedElement.getAnnotation(SHAEncryptBody.class)) != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.SHA).shaEncryptType(encryptBody.value()).build();
        }
        if (annotatedElement.isAnnotationPresent(DESEncryptBody.class) && (encryptBody = annotatedElement.getAnnotation(DESEncryptBody.class)) != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.DES).key(encryptBody.key()).build();
        }
        if (annotatedElement.isAnnotationPresent(AESEncryptBody.class) && (encryptBody = annotatedElement.getAnnotation(AESEncryptBody.class)) != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.AES).key(encryptBody.key()).build();
        }
        if (annotatedElement.isAnnotationPresent(RSAEncryptBody.class) && (encryptBody = annotatedElement.getAnnotation(RSAEncryptBody.class)) != null) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.RSA).key(encryptBody.key()).rsaKeyType(encryptBody.type()).build();
        }
        return null;
    }

    private String switchEncrypt(String formatStringBody, EncryptAnnotationInfoBean infoBean) {
        EncryptBodyMethod method = infoBean.getEncryptBodyMethod();
        if (method == null) {
            throw new EncryptMethodNotFoundException();
        }
        if (method == EncryptBodyMethod.MD5) {
            return SecureUtil.md5().digestHex(formatStringBody);
        }
        if (method == EncryptBodyMethod.SHA) {
            SHAEncryptType shaEncryptType = infoBean.getShaEncryptType();
            if (shaEncryptType == null) {
                shaEncryptType = SHAEncryptType.SHA256;
            }
            return ShaEncryptUtil.encrypt(formatStringBody, shaEncryptType);
        }
        String key = infoBean.getKey();
        if (method == EncryptBodyMethod.DES) {
            key = CommonUtils.checkAndGetKey(this.config.getDesKey(), key, "DES-KEY");
            return SecureUtil.des((byte[])key.getBytes()).encryptHex(formatStringBody);
        }
        if (method == EncryptBodyMethod.AES) {
            key = CommonUtils.checkAndGetKey(this.config.getAesKey(), key, "AES-KEY");
            return SecureUtil.aes((byte[])key.getBytes()).encryptHex(formatStringBody);
        }
        if (method == EncryptBodyMethod.RSA) {
            RSA rsa = CommonUtils.infoBeanToRsaInstance(infoBean);
            return rsa.encryptHex(formatStringBody, infoBean.getRsaKeyType().toolType);
        }
        throw new EncryptBodyFailException();
    }
}

