/*
 * Decompiled with CFR 0.152.
 */
package cn.licoy.encryptbody.config;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class HttpConverterConfig
implements WebMvcConfigurer {
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(){

            protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
                if (object instanceof String) {
                    Charset charset = this.getDefaultCharset();
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    StreamUtils.copy((String)((String)object), (Charset)charset, (OutputStream)outputMessage.getBody());
                } else {
                    super.writeInternal(object, type, outputMessage);
                }
            }
        };
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        MappingJackson2HttpMessageConverter converter = this.mappingJackson2HttpMessageConverter();
        converter.setSupportedMediaTypes((List)new LinkedList<MediaType>(){
            {
                this.add(MediaType.TEXT_HTML);
                this.add(MediaType.APPLICATION_JSON_UTF8);
            }
        });
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)converter);
    }
}

