/*
 * Decompiled with CFR 0.152.
 */
package cn.licoy.encryptbody.util;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.RSA;
import cn.licoy.encryptbody.bean.ISecurityInfo;
import cn.licoy.encryptbody.exception.EncryptBodyFailException;
import cn.licoy.encryptbody.exception.IllegalSecurityTypeException;
import cn.licoy.encryptbody.exception.KeyNotConfiguredException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class CommonUtils {
    public static String checkAndGetKey(String k1, String k2, String keyName) {
        if (StrUtil.isEmpty((CharSequence)k1) && StrUtil.isEmpty((CharSequence)k2)) {
            throw new KeyNotConfiguredException(String.format("%s is not configured (\u672a\u914d\u7f6e%s)", keyName, keyName));
        }
        if (k1 == null) {
            return k2;
        }
        return k1;
    }

    public static RSA infoBeanToRsaInstance(ISecurityInfo info) {
        RSA rsa;
        switch (info.getRsaKeyType()) {
            case PUBLIC: {
                rsa = new RSA(null, SecureUtil.decode((String)info.getKey()));
                break;
            }
            case PRIVATE: {
                rsa = new RSA(SecureUtil.decode((String)info.getKey()), null);
                break;
            }
            default: {
                throw new IllegalSecurityTypeException();
            }
        }
        return rsa;
    }

    public static boolean isConvertToString(Class<?> clazz) {
        return clazz.equals(String.class) || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static String convertToStringOrJson(Object val, ObjectMapper mapper) {
        if (CommonUtils.isConvertToString(val.getClass())) {
            return String.valueOf(val);
        }
        try {
            return mapper.writeValueAsString(val);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new EncryptBodyFailException(e.getMessage());
        }
    }
}

