/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.configuration;

import cn.msuno.restful.api.bean.Info;
import cn.msuno.restful.api.bean.Parameter;
import cn.msuno.restful.api.bean.Swagger;
import cn.msuno.restful.api.configuration.RestfulApiProperties;
import cn.msuno.restful.api.configuration.SwaggerUtils;
import cn.msuno.restful.api.json.JavadocUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={RestfulApiProperties.class})
public class RestfulApiConfiguration {
    private static final Map<String, Swagger> cache = new HashMap<String, Swagger>();
    @Autowired
    private RestfulApiProperties restfulApiProperties;

    @Bean
    @ConditionalOnMissingBean(name={"responseCode"})
    public Map<String, String> responseCode() {
        return new HashMap<String, String>();
    }

    @Bean
    @ConditionalOnMissingBean(value={Info.class})
    public Info apiInfo() {
        Info info = new Info();
        info.setTitle(this.restfulApiProperties.getTitle());
        info.setVersion(this.restfulApiProperties.getVersion());
        info.setTermsOfService(this.restfulApiProperties.getTermsOfService());
        info.setLicense(this.restfulApiProperties.getLicense());
        info.setContact(this.restfulApiProperties.getContact());
        info.setDescription(this.restfulApiProperties.getDescription());
        return info;
    }

    @Bean
    @ConditionalOnMissingBean(name={"globalParameters"})
    public List<Parameter> globalParameters() {
        return Collections.emptyList();
    }

    @Bean
    @ConditionalOnMissingBean(value={Swagger.class})
    public Swagger apiSwagger(@Autowired Map<String, String> responseCode, @Autowired List<Parameter> parameters) {
        Swagger swagger;
        if (cache.containsKey("swagger")) {
            return cache.get("swagger");
        }
        File file = SwaggerUtils.getFile("swagger.json");
        if (null == file) {
            Set<JSONObject> controller = SwaggerUtils.listFiles("./json").stream().map(SwaggerUtils::toJson).collect(Collectors.toSet());
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
            SwaggerUtils.listFiles("./json/res").forEach(v -> map.put(v.getName().replace("_javadoc.json", ""), SwaggerUtils.toJson(v)));
            swagger = JavadocUtils.build(controller, map);
        } else {
            JSONObject object = SwaggerUtils.toJson(file);
            swagger = (Swagger)JSON.parseObject((String)object.toJSONString(), Swagger.class);
        }
        swagger.setInfo(this.apiInfo()).setBasePath(this.restfulApiProperties.getBasePath()).setHost(this.restfulApiProperties.getHost());
        swagger.setStatusCode(responseCode);
        this.buildGlobalParameter(parameters, swagger);
        cache.put("swagger", swagger);
        return swagger;
    }

    private void buildGlobalParameter(List<Parameter> parameters, Swagger swagger) {
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        Map<String, JSONObject> paths = swagger.getPaths();
        for (Map.Entry<String, JSONObject> entry : paths.entrySet()) {
            JSONObject jsonObject = entry.getValue();
            for (Map.Entry en : jsonObject.entrySet()) {
                JSONObject obj = (JSONObject)en.getValue();
                JSONArray jsonArray = obj.getJSONArray("parameters");
                JSONArray array = JSON.parseArray((String)JSON.toJSONString(parameters));
                jsonArray.addAll((Collection)array);
            }
        }
    }
}

