/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.configuration;

import cn.msuno.restful.api.json.JavadocUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerUtils {
    private static Logger logger = LoggerFactory.getLogger(SwaggerUtils.class);

    public static List<File> listFiles(String dirPath) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(dirPath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String path = URLDecoder.decode(url.getFile(), "UTF-8");
                File file = new File(path);
                File[] files = file.listFiles((dir, name) -> name.endsWith("_javadoc.json"));
                result.addAll(Arrays.asList(files));
            }
        }
        catch (IOException e) {
            logger.info("get files error {}", (Object)e.getMessage());
        }
        return result;
    }

    public static File getFile(String name) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("./" + name);
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String path = URLDecoder.decode(url.getFile(), "UTF-8");
                File file = new File(path);
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readFile(File file) {
        if (null == file || file.isDirectory()) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.info("read file error {}", (Object)e.getMessage());
            return null;
        }
    }

    public static JSONObject toJson(String res) {
        JSONObject obj = new JSONObject();
        if (!JavadocUtils.isBlank(res)) {
            obj.putAll((Map)JSONObject.parseObject((String)res, (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect}));
        }
        return obj;
    }

    public static JSONObject toJson(File file) {
        return SwaggerUtils.toJson(SwaggerUtils.readFile(file));
    }
}

