/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.json;

import cn.msuno.restful.api.json.JavadocAsJson;
import cn.msuno.restful.api.json.JavadocUtils;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

class FieldJavadocAsJson
implements JavadocAsJson {
    private final ProcessingEnvironment processingEnv;

    FieldJavadocAsJson(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public JSONObject apply(Element field, String api) {
        JSONObject javaDoc;
        String javadoc = this.processingEnv.getElementUtils().getDocComment(field);
        if (JavadocUtils.isBlank(javadoc)) {
            javadoc = field.getSimpleName().toString();
        }
        if ((javaDoc = JavadocUtils.javaDoc(javadoc)).containsKey((Object)"ignore")) {
            return null;
        }
        JSONObject jsonDoc = new JSONObject();
        JSONObject json = new JSONObject();
        json.put("description", (Object)javaDoc.getOrDefault((Object)"description", (Object)"").toString().trim());
        String toString = field.asType().toString();
        String convertType = JavadocUtils.convertType(toString);
        json.put("type", (Object)convertType);
        if ("integer".equals(convertType)) {
            if (toString.equals("long") || toString.equals("java.lang.Long")) {
                json.put("format", (Object)"int64");
            } else {
                json.put("format", (Object)"int32");
            }
        } else if ("number".equals(convertType)) {
            if (toString.equals("short") || toString.equals("java.lang.Short")) {
                json.put("format", (Object)"int32");
            } else {
                json.put("format", (Object)"double");
            }
        }
        jsonDoc.put(field.getSimpleName().toString(), (Object)json);
        return jsonDoc;
    }
}

