/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.json;

import cn.msuno.restful.api.json.FieldJavadocAsJson;
import cn.msuno.restful.api.json.JavadocAsJson;
import cn.msuno.restful.api.json.JavadocUtils;
import cn.msuno.restful.api.json.MethodJavadocAsJson;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.springframework.web.bind.annotation.RequestMapping;

class JavadocBuilder {
    private final ProcessingEnvironment processingEnv;

    JavadocBuilder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    JSONObject getClassJavadocAsJsonOrNull(TypeElement classElement, String api) {
        JSONObject javaDoc;
        String classDoc = this.processingEnv.getElementUtils().getDocComment(classElement);
        String className = classElement.getQualifiedName().toString();
        if (JavadocUtils.isBlank(classDoc)) {
            classDoc = className;
        }
        if ((javaDoc = JavadocUtils.javaDoc(classDoc)).containsKey((Object)"ignore") || JavadocUtils.isBlank(classDoc)) {
            return null;
        }
        Map<ElementKind, List<Element>> children = this.childElement(classElement);
        List emptyList = Collections.emptyList();
        List<Element> enclosedFields = JavadocBuilder.defaultIfNull(children.get((Object)ElementKind.FIELD), emptyList);
        List<Element> enclosedEnumConstants = JavadocBuilder.defaultIfNull(children.get((Object)ElementKind.ENUM_CONSTANT), emptyList);
        List<Element> enclosedMethods = JavadocBuilder.defaultIfNull(children.get((Object)ElementKind.METHOD), emptyList);
        JSONObject fieldDocs = JavadocBuilder.getJavacAsJson(enclosedFields, new FieldJavadocAsJson(this.processingEnv));
        JSONObject json = new JSONObject();
        json.put("doc", (Object)classDoc);
        json.put("properties", (Object)fieldDocs);
        json.put("name", (Object)className);
        json.put("deprecated", (Object)JavadocBuilder.hasDeprecated(classElement));
        json.put("description", (Object)javaDoc.getOrDefault((Object)"description", (Object)"").toString().trim());
        if ("ELEMENT_API".equals(api)) {
            RequestMapping requestMapping = classElement.getAnnotation(RequestMapping.class);
            String[] value = requestMapping.value();
            String[] consumes = requestMapping.consumes();
            String[] produces = requestMapping.produces();
            json.put("path", (Object)value);
            json.put("consumes", (Object)consumes);
            json.put("produces", (Object)produces);
            JSONArray enumConstantDocs = JavadocBuilder.getJavacAsJson(enclosedEnumConstants, new FieldJavadocAsJson(this.processingEnv), api);
            JSONArray methodDocs = JavadocBuilder.getJavacAsJson(enclosedMethods, new MethodJavadocAsJson(this.processingEnv), api);
            this.buildParam(methodDocs, requestMapping);
            json.put("enumConstants", (Object)enumConstantDocs);
            json.put("methods", (Object)methodDocs);
        }
        return json;
    }

    private Map<ElementKind, List<Element>> childElement(TypeElement typeElement) {
        EnumMap<ElementKind, List<Element>> children = new EnumMap<ElementKind, List<Element>>(ElementKind.class);
        for (Element element : typeElement.getEnclosedElements()) {
            if (!children.containsKey((Object)element.getKind())) {
                children.put(element.getKind(), new ArrayList());
            }
            ((List)children.get((Object)element.getKind())).add(element);
        }
        return children;
    }

    private void buildParam(JSONArray array, RequestMapping requestMapping) {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            if (object.getJSONArray("produces").isEmpty()) {
                object.put("produces", (Object)requestMapping.produces());
            }
            if (object.getJSONArray("consumes").isEmpty()) {
                object.put("consumes", (Object)requestMapping.consumes());
            }
            JSONArray jsonArray = object.getJSONArray("path");
            ArrayList<String> child = new ArrayList<String>();
            for (int j = 0; j < jsonArray.size(); ++j) {
                for (String str : requestMapping.value()) {
                    child.add(str + jsonArray.getString(j));
                }
            }
            object.put("path", child);
        }
    }

    private static JSONArray getJavacAsJson(List<Element> elements, JavadocAsJson createDoc, String api) {
        JSONArray jsonArray = new JSONArray();
        for (Element e : elements) {
            JSONObject eMapped = createDoc.apply(e, api);
            if (eMapped == null) continue;
            jsonArray.add((Object)eMapped);
        }
        return jsonArray;
    }

    private static JSONObject getJavacAsJson(List<Element> elements, JavadocAsJson createDoc) {
        JSONObject jsonObject = new JSONObject();
        for (Element e : elements) {
            JSONObject eMapped = createDoc.apply(e, null);
            if (eMapped == null) continue;
            jsonObject.putAll((Map)eMapped);
        }
        return jsonObject;
    }

    static boolean hasDeprecated(Element element) {
        return element.getAnnotation(Deprecated.class) != null;
    }

    private static <T> T defaultIfNull(T actualValue, T defaultValue) {
        return actualValue != null ? actualValue : defaultValue;
    }
}

