/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.json;

import cn.msuno.restful.api.annotation.EnableRestfulApi;
import cn.msuno.restful.api.bean.Swagger;
import cn.msuno.restful.api.json.JavadocBuilder;
import cn.msuno.restful.api.json.JavadocUtils;
import cn.msuno.restful.api.json.PackageFilter;
import cn.msuno.restful.api.json.RetainJavadoc;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class JavadocProcessor
extends AbstractProcessor {
    private static final Set<TypeElement> controller = new HashSet<TypeElement>();
    private static final Set<TypeElement> other = new HashSet<TypeElement>();
    private static final Set<Element> alreadyProcessed = new HashSet<Element>();
    private static Set<String> buildPath;
    private static boolean type;
    private static Set<JSONObject> controllerSet;
    private static Map<String, JSONObject> beanMap;
    private static boolean hasBuild;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        PackageFilter packageFilter;
        JavadocBuilder jsonJavadocBuilder = new JavadocBuilder(this.processingEnv);
        Map<String, String> options = this.processingEnv.getOptions();
        String packagesOption = options.get("javadoc.packages");
        PackageFilter packageFilter2 = packageFilter = packagesOption == null ? new PackageFilter() : new PackageFilter(packagesOption);
        if (!packageFilter.allowAllPackages()) {
            for (TypeElement typeElement : annotations) {
                if (!JavadocProcessor.isRetainJavadocAnnotation(typeElement)) continue;
                for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                    this.generateJavadoc(element);
                }
            }
        }
        for (Element element : roundEnvironment.getRootElements()) {
            if (!packageFilter.test(element)) continue;
            this.generateJavadoc(element);
        }
        if (Objects.isNull(buildPath)) {
            return false;
        }
        this.build(controller, jsonJavadocBuilder, "json", "ELEMENT_API");
        this.build(other, jsonJavadocBuilder, "json.res", null);
        if (!hasBuild && type) {
            hasBuild = true;
            Swagger swagger = JavadocUtils.build(controllerSet, beanMap);
            try {
                FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "swagger.json", new Element[0]);
                Throwable throwable = null;
                try (OutputStream o = fileObject.openOutputStream();){
                    o.write(JSONObject.toJSONString((Object)swagger).getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Javadoc retention failed; " + iOException);
            }
        }
        return false;
    }

    private void build(Set<TypeElement> list, JavadocBuilder javadocBuilder, String path, String api) {
        for (TypeElement e : list) {
            if (!this.hasContains(e.getQualifiedName().toString()) || !alreadyProcessed.add(e)) continue;
            JSONObject javadoc = javadocBuilder.getClassJavadocAsJsonOrNull(e, api);
            if (null != javadoc && javadoc.size() > 0 && type && JavadocUtils.isBlank(api)) {
                beanMap.put(e.getQualifiedName().toString(), javadoc);
                continue;
            }
            if (null != javadoc && javadoc.size() > 0 && type && "ELEMENT_API".equals(api)) {
                controllerSet.add(javadoc);
                continue;
            }
            if (null == javadoc || javadoc.size() <= 0) continue;
            try {
                this.outputJsonDoc(e, javadoc, path);
            }
            catch (IOException ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Javadoc retention failed; " + ex, e);
            }
        }
    }

    private boolean hasContains(String key) {
        if (buildPath.isEmpty()) {
            return true;
        }
        for (String str : buildPath) {
            if (!key.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    private void generateJavadoc(Element element) {
        ElementKind kind = element.getKind();
        EnableRestfulApi restfulApi = element.getAnnotation(EnableRestfulApi.class);
        if (!Objects.isNull(restfulApi)) {
            if (Objects.isNull(buildPath)) {
                buildPath = new HashSet<String>();
            }
            buildPath.addAll(Arrays.asList(restfulApi.value()));
            type = restfulApi.single();
        }
        if (kind == ElementKind.CLASS || kind == ElementKind.INTERFACE || kind == ElementKind.ENUM) {
            this.generateJavadocForClass(element);
        }
        for (Element element2 : element.getEnclosedElements()) {
            this.generateJavadoc(element2);
        }
    }

    private void generateJavadocForClass(Element element) {
        TypeElement classElement = (TypeElement)element;
        RequestMapping requestMapping = classElement.getAnnotation(RequestMapping.class);
        RestController restController = classElement.getAnnotation(RestController.class);
        if (null == requestMapping || null == restController) {
            other.add(classElement);
        } else {
            controller.add(classElement);
        }
    }

    private void outputJsonDoc(TypeElement classElement, JSONObject classJson, String path) throws IOException {
        String jsonString = classJson.toString();
        FileObject resource = this.createJavadocResourceFile(classElement, path);
        try (OutputStream os = resource.openOutputStream();){
            os.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
    }

    private FileObject createJavadocResourceFile(TypeElement classElement, String path) throws IOException {
        PackageElement packageElement = JavadocProcessor.getPackageElement(classElement);
        String packageName = packageElement.getQualifiedName().toString();
        String relativeName = packageName + "." + JavadocProcessor.getClassName(classElement) + "_javadoc.json";
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, path, relativeName, new Element[0]);
    }

    private static PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return JavadocProcessor.getPackageElement(element.getEnclosingElement());
    }

    private static String getClassName(TypeElement typeElement) {
        String typeName = typeElement.getQualifiedName().toString();
        String packageName = JavadocProcessor.getPackageElement(typeElement).getQualifiedName().toString();
        if (!packageName.isEmpty()) {
            typeName = typeName.substring(packageName.length() + 1);
            typeName = typeName.replace(".", "$");
        }
        return typeName;
    }

    private static boolean isRetainJavadocAnnotation(TypeElement annotation) {
        return annotation.getQualifiedName().toString().equals(RetainJavadoc.class.getName()) || annotation.getAnnotation(RetainJavadoc.class) != null;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.singleton("javadoc.packages");
    }

    static {
        type = false;
        controllerSet = new HashSet<JSONObject>();
        beanMap = new HashMap<String, JSONObject>();
        hasBuild = false;
    }
}

