/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.json;

import cn.msuno.restful.api.json.JavadocAsJson;
import cn.msuno.restful.api.json.JavadocBuilder;
import cn.msuno.restful.api.json.JavadocUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class MethodJavadocAsJson
implements JavadocAsJson {
    private final ProcessingEnvironment processingEnv;

    MethodJavadocAsJson(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public JSONObject apply(Element method, String api) {
        JSONObject javaDoc;
        if (!(method instanceof ExecutableElement)) {
            return null;
        }
        String methodJavadoc = this.processingEnv.getElementUtils().getDocComment(method);
        String methodName = method.getSimpleName().toString();
        if (JavadocUtils.isBlank(methodJavadoc)) {
            methodJavadoc = methodName;
        }
        JSONObject jsonDoc = new JSONObject();
        if ("ELEMENT_API".equals(api)) {
            jsonDoc.putAll((Map)this.getMappingParam(method));
        }
        if ((javaDoc = JavadocUtils.javaDoc(methodJavadoc)).containsKey((Object)"ignore")) {
            return null;
        }
        jsonDoc.put("parameters", (Object)this.getParamErasures((ExecutableElement)method, api, javaDoc.getJSONObject("param")));
        TypeMirror returnType = ((ExecutableElement)method).getReturnType();
        String responseString = returnType.toString();
        jsonDoc.put("absoluteType", (Object)responseString);
        jsonDoc.put("deprecated", (Object)JavadocBuilder.hasDeprecated(method));
        jsonDoc.put("description", (Object)javaDoc.getOrDefault((Object)"description", (Object)"").toString().trim());
        jsonDoc.put("summary", javaDoc.getOrDefault((Object)"summary", (Object)methodName));
        jsonDoc.put("responses", (Object)this.buildResponse(responseString));
        return jsonDoc;
    }

    private JSONObject buildResponse(String responseType) {
        JSONObject res = new JSONObject();
        JSONObject code201 = new JSONObject();
        code201.put("description", (Object)"Created");
        res.put("201", (Object)code201);
        JSONObject code401 = new JSONObject();
        code401.put("description", (Object)"Unauthorized");
        res.put("401", (Object)code401);
        JSONObject code403 = new JSONObject();
        code403.put("description", (Object)"Forbidden");
        res.put("403", (Object)code403);
        JSONObject code404 = new JSONObject();
        code404.put("description", (Object)"Not Found");
        res.put("404", (Object)code404);
        JSONObject code200 = new JSONObject();
        code200.put("description", (Object)"OK");
        JSONObject scheme = new JSONObject();
        if (!responseType.equals(JavadocUtils.convertType(responseType))) {
            scheme.put("type", (Object)JavadocUtils.convertType(responseType));
        } else {
            scheme.put("$ref", (Object)("#/definitions/" + JavadocUtils.getSimpleName(responseType)));
        }
        code200.put("schema", (Object)scheme);
        res.put("200", (Object)code200);
        return res;
    }

    private JSONObject getMappingParam(Element elementMethod) {
        JSONObject jsonDoc = new JSONObject();
        String[] path = null;
        String[] produces = null;
        String[] consumes = null;
        RequestMethod[] method = null;
        RequestMapping requestMapping = elementMethod.getAnnotation(RequestMapping.class);
        PostMapping postMapping = elementMethod.getAnnotation(PostMapping.class);
        GetMapping getMapping = elementMethod.getAnnotation(GetMapping.class);
        DeleteMapping deleteMapping = elementMethod.getAnnotation(DeleteMapping.class);
        PutMapping putMapping = elementMethod.getAnnotation(PutMapping.class);
        if (null != requestMapping) {
            path = requestMapping.value();
            produces = requestMapping.produces();
            consumes = requestMapping.consumes();
            method = requestMapping.method();
            if (method.length < 1) {
                method = new RequestMethod[]{RequestMethod.POST, RequestMethod.GET, RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.OPTIONS};
            }
        }
        if (null != postMapping) {
            path = postMapping.value();
            produces = postMapping.produces();
            consumes = postMapping.consumes();
            method = new RequestMethod[]{RequestMethod.POST};
        }
        if (null != getMapping) {
            path = getMapping.value();
            produces = getMapping.produces();
            consumes = getMapping.consumes();
            method = new RequestMethod[]{RequestMethod.GET};
        }
        if (null != deleteMapping) {
            path = deleteMapping.value();
            produces = deleteMapping.produces();
            consumes = deleteMapping.consumes();
            method = new RequestMethod[]{RequestMethod.DELETE};
        }
        if (null != putMapping) {
            path = putMapping.value();
            produces = putMapping.produces();
            consumes = putMapping.consumes();
            method = new RequestMethod[]{RequestMethod.PUT};
        }
        if (null == path || path.length < 1) {
            return jsonDoc;
        }
        jsonDoc.put("path", (Object)path);
        jsonDoc.put("produces", (Object)produces);
        jsonDoc.put("consumes", (Object)consumes);
        jsonDoc.put("method", (Object)method);
        return jsonDoc;
    }

    private JSONArray getParamErasures(ExecutableElement executableElement, String api, JSONObject methodsDoc) {
        JSONArray jsonValues = new JSONArray();
        for (VariableElement variableElement : executableElement.getParameters()) {
            jsonValues.add((Object)this.getParams(variableElement, api, methodsDoc));
        }
        return jsonValues;
    }

    private JSONObject getParams(VariableElement variableElement, String api, JSONObject methodsDoc) {
        TypeMirror typeMirror = variableElement.asType();
        JSONObject json = new JSONObject();
        String name = variableElement.getSimpleName().toString();
        if ("ELEMENT_API".equals(api)) {
            RequestParam requestParam = variableElement.getAnnotation(RequestParam.class);
            PathVariable pathVariable = variableElement.getAnnotation(PathVariable.class);
            RequestBody requestBody = variableElement.getAnnotation(RequestBody.class);
            String defaultValue = "";
            boolean required = false;
            String in = "query";
            if (null != requestParam) {
                name = requestParam.value();
                defaultValue = requestParam.defaultValue();
                required = requestParam.required();
            }
            if (null != pathVariable) {
                name = pathVariable.value();
                required = pathVariable.required();
                in = "path";
            }
            if (null != requestBody) {
                required = requestBody.required();
                in = "body";
            }
            json.put("in", (Object)in);
            json.put("default", (Object)defaultValue);
            json.put("required", (Object)required);
        }
        json.put("type", (Object)JavadocUtils.convertType(typeMirror.toString()));
        json.put("description", (Object)methodsDoc.getOrDefault((Object)name, methodsDoc.getOrDefault((Object)variableElement.getSimpleName().toString(), (Object)name)).toString());
        json.put("name", (Object)name);
        return json;
    }
}

