/*
 * Decompiled with CFR 0.152.
 */
package cn.msuno.restful.api.json;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;

class PackageFilter {
    private final Set<String> rootPackages = new HashSet<String>();
    private final Set<String> packages = new HashSet<String>();
    private final Set<String> negatives = new HashSet<String>();

    PackageFilter() {
    }

    PackageFilter(String commaDelimitedPackages) {
        for (String pkg : commaDelimitedPackages.split(",")) {
            if ((pkg = pkg.trim()).isEmpty()) continue;
            this.rootPackages.add(pkg);
        }
        this.packages.addAll(this.rootPackages);
    }

    boolean test(Element element) {
        String elementPackage = PackageFilter.getPackage(element);
        if (this.negatives.contains(elementPackage)) {
            return false;
        }
        if (this.packages.isEmpty() || this.packages.contains(elementPackage)) {
            return true;
        }
        for (String p : this.rootPackages) {
            if (!elementPackage.startsWith(p + "$")) continue;
            this.packages.add(elementPackage);
            return true;
        }
        this.negatives.add(elementPackage);
        return false;
    }

    private static String getPackage(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            if ((e = e.getEnclosingElement()) != null) continue;
            return "";
        }
        return ((QualifiedNameable)e).getQualifiedName().toString();
    }

    boolean allowAllPackages() {
        return this.packages.isEmpty();
    }
}

