/*
 * Decompiled with CFR 0.152.
 */
package cn.org.hentai.acodec;

import cn.org.hentai.acodec.AudioCodec;

public final class ADPCMCodec
extends AudioCodec {
    static int[] indexTable = new int[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
    static int[] stepsizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};

    @Override
    public byte[] toPCM(byte[] data) {
        State state = new State();
        int dlen = (data.length - 4) / 2;
        byte[] temp = new byte[data.length - 4];
        System.arraycopy(data, 4, temp, 0, temp.length);
        state.valprev = (short)(data[1] << 8 & 0xFF00 | data[0] & 0xFF);
        state.index = data[2];
        short[] outdata = new short[dlen * 2];
        ADPCMCodec.adpcm_decoder(temp, outdata, dlen * 2, state);
        temp = new byte[dlen * 4];
        int k = 0;
        for (int i = 0; i < outdata.length; ++i) {
            short s = outdata[i];
            temp[k++] = (byte)(s & 0xFF);
            temp[k++] = (byte)(s >> 8 & 0xFF);
        }
        return temp;
    }

    @Override
    public byte[] fromPCM(byte[] data) {
        return null;
    }

    public static void adpcm_coder(short[] indata, byte[] outdata, int len, State state) {
        int outputbuffer = 0;
        byte[] outp = outdata;
        short[] inp = indata;
        int valpred = state.valprev;
        int index = state.index;
        int step = stepsizeTable[index];
        boolean bufferstep = true;
        int k = 0;
        int i = 0;
        while (len > 0) {
            int sign;
            short val = inp[i];
            int diff = val - valpred;
            int n = sign = diff < 0 ? 8 : 0;
            if (sign != 0) {
                diff = -diff;
            }
            int delta = 0;
            int vpdiff = step >> 3;
            if (diff >= step) {
                delta = 4;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 2;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 1;
                vpdiff += step;
            }
            valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
            if (valpred > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            if ((index += indexTable[delta |= sign]) < 0) {
                index = 0;
            }
            if (index > 88) {
                index = 88;
            }
            step = stepsizeTable[index];
            if (bufferstep) {
                outputbuffer = delta << 4 & 0xF0;
            } else {
                outp[k++] = (byte)(delta & 0xF | outputbuffer);
            }
            bufferstep = !bufferstep;
            --len;
            ++i;
        }
        if (!bufferstep) {
            outp[k++] = (byte)outputbuffer;
        }
        state.valprev = (short)valpred;
        state.index = (byte)index;
    }

    public static void adpcm_decoder(byte[] indata, short[] outdata, int len, State state) {
        int inputbuffer = 0;
        short[] outp = outdata;
        byte[] inp = indata;
        int valpred = state.valprev;
        int index = state.index;
        if (index < 0) {
            index = 0;
        }
        if (index > 88) {
            index = 88;
        }
        int step = stepsizeTable[index];
        boolean bufferstep = false;
        int k = 0;
        int i = 0;
        while (len > 0) {
            int delta;
            if (bufferstep) {
                delta = inputbuffer & 0xF;
            } else {
                inputbuffer = inp[i++];
                delta = inputbuffer >> 4 & 0xF;
            }
            boolean bl = bufferstep = !bufferstep;
            if ((index += indexTable[delta]) < 0) {
                index = 0;
            }
            if (index > 88) {
                index = 88;
            }
            int sign = delta & 8;
            int vpdiff = step >> 3;
            if (((delta &= 7) & 4) > 0) {
                vpdiff += step;
            }
            if ((delta & 2) > 0) {
                vpdiff += step >> 1;
            }
            if ((delta & 1) > 0) {
                vpdiff += step >> 2;
            }
            valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
            if (valpred > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            step = stepsizeTable[index];
            outp[k++] = (short)valpred;
            --len;
        }
        state.valprev = (short)valpred;
        state.index = (byte)index;
    }

    public static class State {
        public short valprev;
        public byte index;
    }
}

