/*
 * Decompiled with CFR 0.152.
 */
package cn.org.hentai.acodec;

import cn.org.hentai.acodec.AudioCodec;
import cn.org.hentai.utils.ByteUtils;

public class G711UCodec
extends AudioCodec {
    static final int ULAW = 1;
    static final int ALAW = 2;
    static byte[] linear_to_ulaw;
    static short[] ulaw_to_linear;
    static final int SIGN_BIT = 128;
    static final int QUANT_MASK = 15;
    static final int NSEGS = 8;
    static final int SEG_SHIFT = 4;
    static final int SEG_MASK = 112;
    static final int BIAS = 132;
    static final int CLIP = 8159;
    static short[] seg_aend;
    static short[] seg_uend;
    int[] _u2a = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 29, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128};
    int[] _a2u = new int[]{1, 3, 5, 7, 9, 11, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 48, 49, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};

    static short ulaw2linear(byte u_val) {
        u_val = ~u_val;
        short t = (short)(((u_val & 0xF) << 3) + 132);
        t = (short)(t << ((u_val & 0x70) >>> 4));
        return (u_val & 0x80) > 0 ? (short)(132 - t) : (short)(t - 132);
    }

    static byte linear2ulaw(short pcm_val) {
        short seg;
        int mask;
        if ((pcm_val = (short)(pcm_val >> 2)) < 0) {
            pcm_val = -pcm_val;
            mask = 127;
        } else {
            mask = 255;
        }
        if (pcm_val > 8159) {
            pcm_val = (short)8159;
        }
        if ((seg = G711UCodec.search(pcm_val = (short)(pcm_val + 33), seg_uend, (short)8)) >= 8) {
            return (byte)(0x7F ^ mask);
        }
        byte uval = (byte)(seg << 4 | pcm_val >> seg + 1 & 0xF);
        return (byte)(uval ^ mask);
    }

    static short search(short val, short[] table, short size) {
        for (short i = 0; i < size; i = (short)(i + 1)) {
            if (val > table[i]) continue;
            return i;
        }
        return size;
    }

    static void ulaw_to_pcm16(int src_length, byte[] src_samples, byte[] dst_samples) {
        int k = 0;
        for (int i = 0; i < src_length; ++i) {
            short s = ulaw_to_linear[src_samples[i] & 0xFF];
            dst_samples[k++] = (byte)(s & 0xFF);
            dst_samples[k++] = (byte)(s >> 8 & 0xFF);
        }
    }

    static void pcm16_to_ulaw(int src_length, byte[] src_samples, byte[] dst_samples) {
        short[] s_samples = ByteUtils.toShortArray(src_samples);
        int k = 0;
        for (int i = 0; i < s_samples.length; ++i) {
            dst_samples[k++] = G711UCodec.linear2ulaw(s_samples[i]);
        }
    }

    @Override
    public byte[] toPCM(byte[] data) {
        byte[] dest = new byte[data.length * 2];
        G711UCodec.ulaw_to_pcm16(data.length, data, dest);
        return dest;
    }

    @Override
    public byte[] fromPCM(byte[] data) {
        byte[] dest = new byte[data.length / 2];
        G711UCodec.pcm16_to_ulaw(data.length, data, dest);
        return dest;
    }

    static {
        int i;
        linear_to_ulaw = new byte[65536];
        ulaw_to_linear = new short[256];
        seg_aend = new short[]{31, 63, 127, 255, 511, 1023, 2047, 4095};
        seg_uend = new short[]{63, 127, 255, 511, 1023, 2047, 4095, 8191};
        for (i = 0; i < 256; ++i) {
            G711UCodec.ulaw_to_linear[i] = G711UCodec.ulaw2linear((byte)i);
        }
        for (i = 0; i < 65535; ++i) {
            G711UCodec.linear_to_ulaw[i] = G711UCodec.linear2ulaw((short)i);
        }
    }
}

