/*
 * Decompiled with CFR 0.152.
 */
package com.quinn.hunter.plugin.timing.bytecode;

import com.quinn.hunter.plugin.timing.TimingHunterExtension;
import com.quinn.hunter.plugin.timing.bytecode.TimingClassAdapter;
import com.quinn.hunter.transform.asm.BaseWeaver;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class TimingWeaver
extends BaseWeaver {
    private static final String PLUGIN_LIBRARY = "com.hunter.library.timing";
    private TimingHunterExtension timingHunterExtension;

    public void setExtension(Object extension) {
        if (extension == null) {
            return;
        }
        this.timingHunterExtension = (TimingHunterExtension)extension;
    }

    public boolean isWeavableClass(String fullQualifiedClassName) {
        boolean superResult = super.isWeavableClass(fullQualifiedClassName);
        boolean isByteCodePlugin = fullQualifiedClassName.startsWith(PLUGIN_LIBRARY);
        if (this.timingHunterExtension != null) {
            if (!this.timingHunterExtension.whitelist.isEmpty()) {
                boolean inWhiteList = false;
                for (String item : this.timingHunterExtension.whitelist) {
                    if (!fullQualifiedClassName.startsWith(item)) continue;
                    inWhiteList = true;
                }
                return superResult && !isByteCodePlugin && inWhiteList;
            }
            if (!this.timingHunterExtension.blacklist.isEmpty()) {
                boolean inBlackList = false;
                for (String item : this.timingHunterExtension.blacklist) {
                    if (!fullQualifiedClassName.startsWith(item)) continue;
                    inBlackList = true;
                }
                return superResult && !isByteCodePlugin && !inBlackList;
            }
        }
        return superResult && !isByteCodePlugin;
    }

    protected ClassVisitor wrapClassWriter(ClassWriter classWriter) {
        return new TimingClassAdapter((ClassVisitor)classWriter);
    }
}

