/*
 * Decompiled with CFR 0.152.
 */
package io.rong;

import io.rong.RongCloudConfig;
import io.rong.methods.chatroom.Chatroom;
import io.rong.methods.conversation.Conversation;
import io.rong.methods.group.Group;
import io.rong.methods.message.Message;
import io.rong.methods.push.Push;
import io.rong.methods.sensitive.SensitiveWord;
import io.rong.methods.sensitive.Wordfilter;
import io.rong.methods.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class RongCloud {
    private static ConcurrentHashMap<String, RongCloud> rongCloud = new ConcurrentHashMap();
    public User user;
    public Message message;
    public Wordfilter wordfilter;
    public SensitiveWord sensitiveword;
    public Group group;
    public Chatroom chatroom;
    public Conversation conversation;
    public Push push;
    public final RongCloudConfig config;

    public RongCloudConfig getConfig() {
        return this.config;
    }

    private RongCloud(String appKey, String appSecret, RongCloudConfig config) {
        this.user = new User(appKey, appSecret, this);
        this.message = new Message(appKey, appSecret);
        this.message.setRongCloud(this);
        this.wordfilter = new Wordfilter(appKey, appSecret);
        this.wordfilter.setRongCloud(this);
        this.sensitiveword = new SensitiveWord(appKey, appSecret);
        this.sensitiveword.setRongCloud(this);
        this.group = new Group(appKey, appSecret, this);
        this.chatroom = new Chatroom(appKey, appSecret, this);
        this.chatroom.setRongCloud(this);
        this.conversation = new Conversation(appKey, appSecret);
        this.conversation.setRongCloud(this);
        this.push = new Push(appKey, appSecret);
        this.push.setRongCloud(this);
        this.config = config;
    }

    public static RongCloud getInstance(String appKey, String appSecret) {
        return RongCloud.getInstance(appKey, appSecret, RongCloudConfig.DefaultConfig);
    }

    public static RongCloud getSingaporeInstance(String appKey, String appSecret) {
        return RongCloud.getInstance(appKey, appSecret, RongCloudConfig.SingaporeConfig);
    }

    public static RongCloud getInstance(String appKey, String appSecret, RongCloudConfig config) {
        if (null == rongCloud.get(appKey)) {
            RongCloud rc = new RongCloud(appKey, appSecret, config);
            rongCloud.putIfAbsent(appKey, rc);
        }
        return rongCloud.get(appKey);
    }

    @Deprecated
    public static RongCloud getInstance(String appKey, String appSecret, String api) {
        return RongCloud.getInstance(appKey, appSecret, new RongCloudConfig(api));
    }

    @Deprecated
    public static RongCloud getInstance(String appKey, String appSecret, String api, List<String> apiBackUp) {
        ArrayList<String> apiList = new ArrayList<String>();
        if (api != null) {
            apiList.add(api);
        }
        if (apiBackUp != null && apiBackUp.size() > 0) {
            for (String item : apiBackUp) {
                if (item == null) continue;
                apiList.add(item);
            }
        }
        return RongCloud.getInstance(appKey, appSecret, new RongCloudConfig(apiList));
    }
}

