/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.group;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.message.GroupMessage;
import io.rong.models.message.GroupStatusMessage;
import io.rong.models.message.MentionMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class Group {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "message/group";
    private static final String RECAL_PATH = "message/recall";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Group(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult send(GroupMessage message) throws Exception {
        String body;
        String code = CommonUtil.checkFiled(message, PATH, "send");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        for (int i = 0; i < message.getTargetId().length; ++i) {
            String child = message.getTargetId()[i];
            if (null == child) continue;
            sb.append("&toGroupId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent().toString(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData(), UTF8));
        }
        if (message.getPushExt() != null) {
            sb.append("&pushExt=").append(URLEncoder.encode(message.getPushExt(), UTF8));
        }
        if (message.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(message.getIsPersisted().toString(), UTF8));
        }
        if (message.getIsIncludeSender() != null) {
            sb.append("&isIncludeSender=").append(URLEncoder.encode(message.getIsIncludeSender().toString(), UTF8));
        }
        if (message.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(message.getContentAvailable().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/group/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }

    public ResponseResult sendMention(MentionMessage message) throws Exception {
        String body;
        String code = CommonUtil.checkFiled(message, PATH, "sendMention");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        if (null == message.getContent().getMentionedInfo()) {
            return new ResponseResult(1002, "mentionedInfo \u53c2\u6570\u4e3a\u5fc5\u4f20\u9879");
        }
        if (null == message.getContent().getContent()) {
            return new ResponseResult(1002, "MentionMessageContent.content \u53c2\u6570\u4e3a\u5fc5\u4f20\u9879");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        String[] groupIds = message.getTargetId();
        for (int i = 0; i < groupIds.length; ++i) {
            String child = groupIds[i];
            sb.append("&toGroupId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent().toString(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData(), UTF8));
        }
        if (message.getPushExt() != null) {
            sb.append("&pushExt=").append(URLEncoder.encode(message.getPushExt(), UTF8));
        }
        if (message.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(message.getIsPersisted().toString(), UTF8));
        }
        if (message.getIsCounted() != null) {
            sb.append("&isCounted=").append(URLEncoder.encode(message.getIsCounted().toString(), UTF8));
        }
        if (message.getIsIncludeSender() != null) {
            sb.append("&isIncludeSender=").append(URLEncoder.encode(message.getIsIncludeSender().toString(), UTF8));
        }
        sb.append("&isMentioned=").append(URLEncoder.encode("1", UTF8));
        if (message.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(message.getContentAvailable().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/group/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }

    public ResponseResult sendDirection(GroupMessage message) throws Exception {
        String body;
        int i;
        String code = CommonUtil.checkFiled(message, PATH, "send");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        if (message.getTargetId().length > 1) {
            return new ResponseResult(20005, "\u7fa4\u5b9a\u5411\u6d88\u606f\u5f53\u7fa4\u7ec4 Id \u4e3a\u4e00\u4e2a\u65f6\u6709\u6548 ");
        }
        if (null == message.getToUserId() && message.getToUserId().length < 1) {
            return new ResponseResult(20005, "toUserId \u5fc5\u4f20 ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        for (i = 0; i < message.getTargetId().length; ++i) {
            String child = message.getTargetId()[i];
            if (null == child) continue;
            sb.append("&toGroupId=").append(URLEncoder.encode(child, UTF8));
        }
        for (i = 0; i < message.getToUserId().length; ++i) {
            String toId = message.getToUserId()[i];
            if (null == toId) continue;
            sb.append("&toUserId=").append(URLEncoder.encode(toId, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData(), UTF8));
        }
        if (message.getPushExt() != null) {
            sb.append("&pushExt=").append(URLEncoder.encode(message.getPushExt(), UTF8));
        }
        if (message.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(message.getIsPersisted().toString(), UTF8));
        }
        if (message.getIsIncludeSender() != null) {
            sb.append("&isIncludeSender=").append(URLEncoder.encode(message.getIsIncludeSender().toString(), UTF8));
        }
        if (message.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(message.getContentAvailable().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/group/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }

    public Result recall(RecallMessage message) throws Exception {
        String errMsg = CommonUtil.checkFiled(message, RECAL_PATH, "recall");
        if (null != errMsg) {
            return (Result)GsonUtil.fromJson(errMsg, Result.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode("3", UTF8));
        sb.append("&fromUserId=").append(URLEncoder.encode(message.senderId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(message.targetId.toString(), UTF8));
        sb.append("&messageUID=").append(URLEncoder.encode(message.uId.toString(), UTF8));
        sb.append("&sentTime=").append(URLEncoder.encode(message.sentTime.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/recall.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "recall", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult sendStatusMessage(GroupStatusMessage message) throws Exception {
        String errMsg = CommonUtil.checkFiled(message, PATH, "sendGroupStatus");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId(), UTF8));
        for (int i = 0; i < message.getGroupId().length; ++i) {
            String child = message.getGroupId()[i];
            if (null == child) continue;
            sb.append("&toGroupId=").append(URLEncoder.encode(child, UTF8));
        }
        if (!StringUtils.isBlank((CharSequence)message.getObjectName())) {
            sb.append("&objectName=").append(URLEncoder.encode(message.getObjectName(), UTF8));
        } else {
            sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        }
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        sb.append("&verifyBlacklist=").append(URLEncoder.encode(String.valueOf(message.getVerifyBlacklist()), UTF8));
        sb.append("&isIncludeSender=").append(URLEncoder.encode(String.valueOf(message.getIsIncludeSender()), UTF8));
        sb.append("&isPersisted=").append(URLEncoder.encode(String.valueOf("0"), UTF8));
        sb.append("&isCounted=").append(URLEncoder.encode(String.valueOf("0"), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/statusmessage/group/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sendGroupStatus", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }
}

