/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.spring.magic.ioc;

import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class BeanFactoryAwareBean
implements BeanFactoryAware {
    private static final Logger LOGGER = Logger.getLogger(BeanFactoryAwareBean.class.getName());
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String[] getDependenciesForBean(String beanName) {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).getDependenciesForBean(beanName);
        }
        LOGGER.warning("this factory doesn't support this method.");
        return new String[0];
    }

    public void registerDependentForBean(String beanName, String dependentBeanName) {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)this.beanFactory).registerDependentBean(beanName, dependentBeanName);
            this.beanFactory.getBean(beanName);
        } else {
            LOGGER.warning("this factory doesn't support this method.");
        }
    }

    public Object getBean(String beanId) {
        return this.beanFactory.getBean(beanId);
    }

    public Object getBean(String name, Class<?> classType) {
        return this.beanFactory.getBean(name, classType);
    }
}

