/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.spring.magic.ioc.setter;

import cn.sexycode.spring.magic.ioc.BeanFactoryAwareBean;
import cn.sexycode.spring.magic.ioc.setter.BeanDependencySetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;

public class SetterMethodBeanDependencySetter
implements BeanDependencySetter {
    private static final Logger LOGGER = Logger.getLogger(SetterMethodBeanDependencySetter.class.getName());
    private BeanFactoryAwareBean beanFactory;

    public SetterMethodBeanDependencySetter(BeanFactoryAwareBean beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object setDependency(Object bean, String depName, Object newDep) {
        Object propertyValue;
        block5: {
            BeanWrapperImpl wrapper;
            block4: {
                wrapper = new BeanWrapperImpl(bean);
                propertyValue = null;
                try {
                    propertyValue = wrapper.getPropertyValue(depName);
                }
                catch (BeansException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    String msg = "\u672a\u83b7\u53d6\u5230 %s \u5c5e\u6027 %s \u503c, \u5f02\u5e38\u4fe1\u606f\u4e3a:%s";
                    LOGGER.info(String.format(msg, bean, depName, e.getMessage()));
                }
            }
            try {
                wrapper.setPropertyValue(depName, newDep);
            }
            catch (BeansException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.info(String.format("\u8bbe\u7f6e %s \u5c5e\u6027 %s \u503c\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a: %s", bean, depName, e.getMessage()));
            }
        }
        return propertyValue;
    }

    @Override
    public Object setDependency(String beanId, String depName, String newDepId) {
        return this.setDependency(this.beanFactory.getBean(beanId), depName, this.beanFactory.getBean(newDepId));
    }
}

